/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.geysermc.floodgate.news.NewsItem;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.floodgate.news.data.AnnouncementData;
import org.geysermc.floodgate.news.data.BuildSpecificData;
import org.geysermc.floodgate.news.data.CheckAfterData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.WebUtils;

public class NewsHandler {
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();
    private final Gson gson = new Gson();
    private final Map<Integer, NewsItem> activeNewsItems = new HashMap<Integer, NewsItem>();
    private final String branch;
    private final int build;
    private boolean firstCheck = true;

    public NewsHandler(String branch, int build) {
        this.branch = branch;
        this.build = build;
        this.executorService.scheduleWithFixedDelay(this::checkNews, 0L, 30L, TimeUnit.MINUTES);
    }

    private void schedule(long delayMs) {
        this.executorService.schedule(this::checkNews, delayMs, TimeUnit.MILLISECONDS);
    }

    private void checkNews() {
        try {
            String body = WebUtils.getBody("https://api.geysermc.org/v2/news/geyser");
            JsonArray array = this.gson.fromJson(body, JsonArray.class);
            try {
                for (JsonElement newsItemElement : array) {
                    NewsItem newsItem = NewsItem.readItem(newsItemElement.getAsJsonObject());
                    if (newsItem == null) continue;
                    this.addNews(newsItem);
                }
                this.firstCheck = false;
            }
            catch (Exception e) {
                if (this.logger.isDebug()) {
                    this.logger.error("Error while reading news item", e);
                }
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            // empty catch block
        }
    }

    public void handleNews(GeyserSession session, NewsItemAction action) {
        for (NewsItem news : this.getActiveNews(action)) {
            this.handleNewsItem(session, news, action);
        }
    }

    private void handleNewsItem(GeyserSession session, NewsItem news, NewsItemAction action) {
        switch (action) {
            case ON_SERVER_STARTED: {
                if (!this.firstCheck) {
                    return;
                }
            }
            case BROADCAST_TO_CONSOLE: {
                this.logger.info(news.getMessage());
                break;
            }
            case ON_OPERATOR_JOIN: {
                break;
            }
            case BROADCAST_TO_OPERATORS: {
                for (GeyserSession player : GeyserImpl.getInstance().getSessionManager().getSessions().values()) {
                    if (player.getOpPermissionLevel() < 2) continue;
                    session.sendMessage("\u00a7a" + news.getMessage());
                }
                break;
            }
        }
    }

    public Collection<NewsItem> getActiveNews() {
        return this.activeNewsItems.values();
    }

    public Collection<NewsItem> getActiveNews(NewsItemAction action) {
        ArrayList<NewsItem> news = new ArrayList<NewsItem>();
        for (NewsItem item : this.getActiveNews()) {
            if (!item.getActions().contains((Object)action)) continue;
            news.add(item);
        }
        return news;
    }

    public void addNews(NewsItem item) {
        if (this.activeNewsItems.containsKey(item.getId())) {
            if (!item.isActive()) {
                this.activeNewsItems.remove(item.getId());
            }
            return;
        }
        if (!item.isActive()) {
            return;
        }
        switch (item.getType()) {
            case ANNOUNCEMENT: {
                if (item.getDataAs(AnnouncementData.class).isAffected("geyser")) break;
                return;
            }
            case BUILD_SPECIFIC: {
                if (item.getDataAs(BuildSpecificData.class).isAffected(this.branch, this.build)) break;
                return;
            }
            case CHECK_AFTER: {
                long checkAfter = item.getDataAs(CheckAfterData.class).getCheckAfter();
                long delayMs = System.currentTimeMillis() - checkAfter;
                this.schedule(delayMs > 0L ? delayMs : 0L);
                break;
            }
        }
        this.activeNewsItems.put(item.getId(), item);
        this.activateNews(item);
    }

    private void activateNews(NewsItem item) {
        for (NewsItemAction action : item.getActions()) {
            this.handleNewsItem(null, item, action);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

