/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import com.google.common.collect.SortedSetMultimap;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;

public final class ItemMapping {
    public static final ItemMapping AIR = new ItemMapping("minecraft:air", ItemDefinition.AIR, 0, null, null, null, null, Items.AIR);
    private final String bedrockIdentifier;
    private final ItemDefinition bedrockDefinition;
    private final int bedrockData;
    private final BlockDefinition bedrockBlockDefinition;
    private final String toolType;
    private final String translationString;
    private final @Nullable SortedSetMultimap<Key, GeyserCustomMappingData> customItemDefinitions;
    private final @NonNull Item javaItem;

    public boolean isBlock() {
        return this.bedrockBlockDefinition != null;
    }

    public boolean hasTranslation() {
        return this.translationString != null;
    }

    public boolean isTool() {
        return this.toolType != null;
    }

    ItemMapping(String bedrockIdentifier, ItemDefinition bedrockDefinition, int bedrockData, BlockDefinition bedrockBlockDefinition, String toolType, String translationString, @Nullable SortedSetMultimap<Key, GeyserCustomMappingData> customItemDefinitions, @NonNull Item javaItem) {
        if (javaItem == null) {
            throw new NullPointerException("javaItem is marked non-null but is null");
        }
        this.bedrockIdentifier = bedrockIdentifier;
        this.bedrockDefinition = bedrockDefinition;
        this.bedrockData = bedrockData;
        this.bedrockBlockDefinition = bedrockBlockDefinition;
        this.toolType = toolType;
        this.translationString = translationString;
        this.customItemDefinitions = customItemDefinitions;
        this.javaItem = javaItem;
    }

    public static ItemMappingBuilder builder() {
        return new ItemMappingBuilder();
    }

    public String getBedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    public ItemDefinition getBedrockDefinition() {
        return this.bedrockDefinition;
    }

    public int getBedrockData() {
        return this.bedrockData;
    }

    public BlockDefinition getBedrockBlockDefinition() {
        return this.bedrockBlockDefinition;
    }

    public String getToolType() {
        return this.toolType;
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public @Nullable SortedSetMultimap<Key, GeyserCustomMappingData> getCustomItemDefinitions() {
        return this.customItemDefinitions;
    }

    public @NonNull Item getJavaItem() {
        return this.javaItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemMapping)) {
            return false;
        }
        ItemMapping other = (ItemMapping)o;
        if (this.getBedrockData() != other.getBedrockData()) {
            return false;
        }
        String this$bedrockIdentifier = this.getBedrockIdentifier();
        String other$bedrockIdentifier = other.getBedrockIdentifier();
        if (this$bedrockIdentifier == null ? other$bedrockIdentifier != null : !this$bedrockIdentifier.equals(other$bedrockIdentifier)) {
            return false;
        }
        ItemDefinition this$bedrockDefinition = this.getBedrockDefinition();
        ItemDefinition other$bedrockDefinition = other.getBedrockDefinition();
        if (this$bedrockDefinition == null ? other$bedrockDefinition != null : !this$bedrockDefinition.equals(other$bedrockDefinition)) {
            return false;
        }
        BlockDefinition this$bedrockBlockDefinition = this.getBedrockBlockDefinition();
        BlockDefinition other$bedrockBlockDefinition = other.getBedrockBlockDefinition();
        if (this$bedrockBlockDefinition == null ? other$bedrockBlockDefinition != null : !this$bedrockBlockDefinition.equals(other$bedrockBlockDefinition)) {
            return false;
        }
        String this$toolType = this.getToolType();
        String other$toolType = other.getToolType();
        if (this$toolType == null ? other$toolType != null : !this$toolType.equals(other$toolType)) {
            return false;
        }
        String this$translationString = this.getTranslationString();
        String other$translationString = other.getTranslationString();
        if (this$translationString == null ? other$translationString != null : !this$translationString.equals(other$translationString)) {
            return false;
        }
        SortedSetMultimap<Key, GeyserCustomMappingData> this$customItemDefinitions = this.getCustomItemDefinitions();
        SortedSetMultimap<Key, GeyserCustomMappingData> other$customItemDefinitions = other.getCustomItemDefinitions();
        if (this$customItemDefinitions == null ? other$customItemDefinitions != null : !this$customItemDefinitions.equals(other$customItemDefinitions)) {
            return false;
        }
        Item this$javaItem = this.getJavaItem();
        Item other$javaItem = other.getJavaItem();
        return !(this$javaItem == null ? other$javaItem != null : !this$javaItem.equals(other$javaItem));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBedrockData();
        String $bedrockIdentifier = this.getBedrockIdentifier();
        result = result * 59 + ($bedrockIdentifier == null ? 43 : $bedrockIdentifier.hashCode());
        ItemDefinition $bedrockDefinition = this.getBedrockDefinition();
        result = result * 59 + ($bedrockDefinition == null ? 43 : $bedrockDefinition.hashCode());
        BlockDefinition $bedrockBlockDefinition = this.getBedrockBlockDefinition();
        result = result * 59 + ($bedrockBlockDefinition == null ? 43 : $bedrockBlockDefinition.hashCode());
        String $toolType = this.getToolType();
        result = result * 59 + ($toolType == null ? 43 : $toolType.hashCode());
        String $translationString = this.getTranslationString();
        result = result * 59 + ($translationString == null ? 43 : $translationString.hashCode());
        SortedSetMultimap<Key, GeyserCustomMappingData> $customItemDefinitions = this.getCustomItemDefinitions();
        result = result * 59 + ($customItemDefinitions == null ? 43 : $customItemDefinitions.hashCode());
        Item $javaItem = this.getJavaItem();
        result = result * 59 + ($javaItem == null ? 43 : $javaItem.hashCode());
        return result;
    }

    public String toString() {
        return "ItemMapping(bedrockIdentifier=" + this.getBedrockIdentifier() + ", bedrockDefinition=" + String.valueOf(this.getBedrockDefinition()) + ", bedrockData=" + this.getBedrockData() + ", bedrockBlockDefinition=" + String.valueOf(this.getBedrockBlockDefinition()) + ", toolType=" + this.getToolType() + ", translationString=" + this.getTranslationString() + ", customItemDefinitions=" + String.valueOf(this.getCustomItemDefinitions()) + ", javaItem=" + String.valueOf(this.getJavaItem()) + ")";
    }

    public static class ItemMappingBuilder {
        private String bedrockIdentifier;
        private ItemDefinition bedrockDefinition;
        private int bedrockData;
        private BlockDefinition bedrockBlockDefinition;
        private String toolType;
        private String translationString;
        private SortedSetMultimap<Key, GeyserCustomMappingData> customItemDefinitions;
        private Item javaItem;

        ItemMappingBuilder() {
        }

        public ItemMappingBuilder bedrockIdentifier(String bedrockIdentifier) {
            this.bedrockIdentifier = bedrockIdentifier;
            return this;
        }

        public ItemMappingBuilder bedrockDefinition(ItemDefinition bedrockDefinition) {
            this.bedrockDefinition = bedrockDefinition;
            return this;
        }

        public ItemMappingBuilder bedrockData(int bedrockData) {
            this.bedrockData = bedrockData;
            return this;
        }

        public ItemMappingBuilder bedrockBlockDefinition(BlockDefinition bedrockBlockDefinition) {
            this.bedrockBlockDefinition = bedrockBlockDefinition;
            return this;
        }

        public ItemMappingBuilder toolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        public ItemMappingBuilder translationString(String translationString) {
            this.translationString = translationString;
            return this;
        }

        public ItemMappingBuilder customItemDefinitions(@Nullable SortedSetMultimap<Key, GeyserCustomMappingData> customItemDefinitions) {
            this.customItemDefinitions = customItemDefinitions;
            return this;
        }

        public ItemMappingBuilder javaItem(@NonNull Item javaItem) {
            if (javaItem == null) {
                throw new NullPointerException("javaItem is marked non-null but is null");
            }
            this.javaItem = javaItem;
            return this;
        }

        public ItemMapping build() {
            return new ItemMapping(this.bedrockIdentifier, this.bedrockDefinition, this.bedrockData, this.bedrockBlockDefinition, this.toolType, this.translationString, this.customItemDefinitions, this.javaItem);
        }

        public String toString() {
            return "ItemMapping.ItemMappingBuilder(bedrockIdentifier=" + this.bedrockIdentifier + ", bedrockDefinition=" + String.valueOf(this.bedrockDefinition) + ", bedrockData=" + this.bedrockData + ", bedrockBlockDefinition=" + String.valueOf(this.bedrockBlockDefinition) + ", toolType=" + this.toolType + ", translationString=" + this.translationString + ", customItemDefinitions=" + String.valueOf(this.customItemDefinitions) + ", javaItem=" + String.valueOf(this.javaItem) + ")";
        }
    }
}

