/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.definition;

import com.google.gson.JsonElement;
import java.util.function.BiConsumer;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.predicate.item.ItemRangeDispatchPredicate;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.definition.ItemDefinitionReader;
import org.geysermc.geyser.registry.mappings.definition.SingleDefinitionReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class LegacyDefinitionReader
implements ItemDefinitionReader {
    @Override
    public void readDefinition(JsonElement data, Identifier vanillaItem, Identifier parentModel, BiConsumer<Identifier, CustomItemDefinition> consumer) throws InvalidCustomMappingsFileException {
        Identifier bedrockIdentifier = ItemDefinitionReader.readBedrockIdentifier(data, "legacy item definition");
        String context = "item definition (bedrock identifier=" + String.valueOf(bedrockIdentifier) + ")";
        int customModelData = MappingsUtil.readOrThrow(data, "custom_model_data", NodeReader.INT, context);
        CustomItemDefinition.Builder builder = CustomItemDefinition.builder(bedrockIdentifier, vanillaItem);
        builder.predicate(ItemRangeDispatchPredicate.legacyCustomModelData(customModelData));
        SingleDefinitionReader.readDefinitionBase(builder, data, context);
        consumer.accept(vanillaItem, builder.build());
    }
}

