/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.platform.standalone.gui.ColorPane;
import org.geysermc.geyser.platform.standalone.gui.GraphPanel;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserStandaloneGUI {
    private static final long MEGABYTE = 0x100000L;
    private final GeyserLogger logger;
    private final ColorPane consolePane = new ColorPane();
    private final int originalFontSize = this.consolePane.getFont().getSize();
    private final JTextField commandInput = new JTextField();
    private final CommandListener commandListener = new CommandListener();
    private final GraphPanel ramGraph = new GraphPanel();
    private final List<Integer> ramValues = new ArrayList<Integer>();
    private final DefaultTableModel playerTableModel = new DefaultTableModel();

    public GeyserStandaloneGUI(GeyserLogger logger) {
        this.logger = logger;
        final JFrame frame = new JFrame(GeyserLocale.getLocaleStringLog("geyser.gui.title"));
        frame.setDefaultCloseOperation(0);
        frame.setSize(800, 400);
        frame.setMinimumSize(frame.getSize());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Object[] buttons = new String[]{GeyserLocale.getLocaleStringLog("geyser.gui.exit.confirm"), GeyserLocale.getLocaleStringLog("geyser.gui.exit.deny")};
                int result = JOptionPane.showOptionDialog(frame, GeyserLocale.getLocaleStringLog("geyser.gui.exit.message"), frame.getTitle(), 0, 2, null, buttons, buttons[1]);
                if (result == 0) {
                    System.exit(0);
                }
            }
        });
        Container cp = frame.getContentPane();
        URL image = this.getClass().getClassLoader().getResource("assets/geyser/icon.png");
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            frame.setIconImage(icon.getImage());
        }
        this.setupMenuBar(frame);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(600);
        splitPane.addPropertyChangeListener("dividerLocation", e -> this.splitPaneLimit((JSplitPane)e.getSource()));
        splitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GeyserStandaloneGUI.this.splitPaneLimit((JSplitPane)e.getSource());
            }
        });
        cp.add((Component)splitPane, "Center");
        JPanel leftPane = new JPanel(new BorderLayout());
        splitPane.setLeftComponent(leftPane);
        this.consolePane.setBackground(Color.BLACK);
        this.consolePane.setEditable(false);
        JScrollPane consoleScrollPane = new JScrollPane(this.consolePane);
        leftPane.add((Component)consoleScrollPane, "Center");
        this.commandInput.setPreferredSize(new Dimension(100, 25));
        this.commandInput.setEnabled(false);
        this.commandInput.addActionListener(this.commandListener);
        leftPane.add((Component)this.commandInput, "South");
        JPanel rightPane = new JPanel();
        rightPane.setLayout(new CardLayout(5, 5));
        splitPane.setRightComponent(rightPane);
        JPanel rightContentPane = new JPanel();
        rightContentPane.setLayout(new GridLayout(2, 1, 5, 5));
        rightPane.add(rightContentPane);
        for (int i = 0; i < 10; ++i) {
            this.ramValues.add(0);
        }
        this.ramGraph.setValues(this.ramValues);
        this.ramGraph.setXLabel(GeyserLocale.getLocaleStringLog("geyser.gui.graph.loading"));
        rightContentPane.add(this.ramGraph);
        this.playerTableModel.addColumn(GeyserLocale.getLocaleStringLog("geyser.gui.table.ip"));
        this.playerTableModel.addColumn(GeyserLocale.getLocaleStringLog("geyser.gui.table.username"));
        JTable playerTable = new JTable(this.playerTableModel);
        JScrollPane playerScrollPane = new JScrollPane(playerTable);
        rightContentPane.add(playerScrollPane);
        frame.setVisible(true);
    }

    private void setupMenuBar(JFrame frame) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(GeyserLocale.getLocaleStringLog("geyser.gui.menu.file"));
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem openButton = new JMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.file.open_folder"), 79);
        openButton.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        openButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File("./"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        fileMenu.add(openButton);
        fileMenu.addSeparator();
        JMenuItem exitButton = new JMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.file.exit"), 88);
        exitButton.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        exitButton.addActionListener(e -> System.exit(0));
        fileMenu.add(exitButton);
        JMenu viewMenu = new JMenu(GeyserLocale.getLocaleStringLog("geyser.gui.menu.view"));
        viewMenu.setMnemonic(86);
        menuBar.add(viewMenu);
        JMenuItem zoomInButton = new JMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.view.zoom_in"));
        zoomInButton.setAccelerator(KeyStroke.getKeyStroke(61, 128));
        zoomInButton.addActionListener(e -> this.consolePane.setFont(new Font(this.consolePane.getFont().getName(), this.consolePane.getFont().getStyle(), this.consolePane.getFont().getSize() + 1)));
        viewMenu.add(zoomInButton);
        JMenuItem zoomOutButton = new JMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.view.zoom_out"));
        zoomOutButton.setAccelerator(KeyStroke.getKeyStroke(45, 128));
        zoomOutButton.addActionListener(e -> this.consolePane.setFont(new Font(this.consolePane.getFont().getName(), this.consolePane.getFont().getStyle(), this.consolePane.getFont().getSize() - 1)));
        viewMenu.add(zoomOutButton);
        JMenuItem resetZoomButton = new JMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.view.reset_zoom"));
        resetZoomButton.addActionListener(e -> this.consolePane.setFont(new Font(this.consolePane.getFont().getName(), this.consolePane.getFont().getStyle(), this.originalFontSize)));
        viewMenu.add(resetZoomButton);
        JMenu optionsMenu = new JMenu(GeyserLocale.getLocaleStringLog("geyser.gui.menu.options"));
        viewMenu.setMnemonic(79);
        menuBar.add(optionsMenu);
        JCheckBoxMenuItem debugMode = new JCheckBoxMenuItem(GeyserLocale.getLocaleStringLog("geyser.gui.menu.options.toggle_debug_mode"));
        debugMode.setSelected(this.logger.isDebug());
        debugMode.addActionListener(e -> this.logger.setDebug(debugMode.getState()));
        optionsMenu.add(debugMode);
        frame.setJMenuBar(menuBar);
    }

    private void appendConsole(String text) {
        SwingUtilities.invokeLater(() -> {
            this.consolePane.appendANSI(text);
            Document doc = this.consolePane.getDocument();
            this.consolePane.setCaretPosition(doc.getLength());
        });
    }

    public void addGuiAppender() {
        new GUIAppender().start();
    }

    public void enableCommands(ScheduledExecutorService executor, CommandRegistry registry) {
        this.commandListener.dispatcher = cmd -> executor.execute(() -> registry.runCommand(this.logger, (String)cmd));
        this.commandInput.setEnabled(true);
        this.commandInput.requestFocusInWindow();
    }

    public void startUpdateThread() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Runnable periodicTask = () -> {
            if (GeyserImpl.getInstance() != null) {
                this.playerTableModel.getDataVector().removeAllElements();
                for (GeyserSession player : GeyserImpl.getInstance().getSessionManager().getSessions().values()) {
                    Vector<String> row = new Vector<String>();
                    row.add(player.getSocketAddress().getHostName());
                    row.add(player.getPlayerEntity().getUsername());
                    this.playerTableModel.addRow(row);
                }
                this.playerTableModel.fireTableDataChanged();
            }
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            int freePercent = (int)((double)freeMemory * 100.0 / (double)totalMemory + 0.5);
            this.ramValues.add(100 - freePercent);
            this.ramGraph.setXLabel(GeyserLocale.getLocaleStringLog("geyser.gui.graph.usage", String.format("%,d", (totalMemory - freeMemory) / 0x100000L), freePercent));
            int k = this.ramValues.size();
            if (k > 10) {
                this.ramValues.subList(0, k - 10).clear();
            }
            this.ramGraph.setValues(this.ramValues);
        };
        executor.scheduleAtFixedRate(() -> SwingUtilities.invokeLater(periodicTask), 0L, 1L, TimeUnit.SECONDS);
    }

    private void splitPaneLimit(JSplitPane splitPane) {
        JRootPane frame = splitPane.getRootPane();
        int location = splitPane.getDividerLocation();
        if ((float)location < (float)frame.getWidth() - (float)frame.getWidth() * 0.4f) {
            splitPane.setDividerLocation(Math.round((float)frame.getWidth() - (float)frame.getWidth() * 0.4f));
        } else if (location > frame.getWidth() - 200) {
            splitPane.setDividerLocation(frame.getWidth() - 200);
        }
    }

    private class CommandListener
    implements ActionListener {
        private Consumer<String> dispatcher;

        private CommandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = GeyserStandaloneGUI.this.commandInput.getText().stripTrailing();
            GeyserStandaloneGUI.this.appendConsole(command + "\n");
            this.dispatcher.accept(command);
            GeyserStandaloneGUI.this.commandInput.setText("");
        }
    }

    private class GUIAppender
    extends AbstractAppender {
        private static final List<PatternFormatter> FORMATTERS = PatternLayout.createPatternParser(new NullConfiguration()).parse("[%d{HH:mm:ss} %style{%highlight{%level}{FATAL=red, ERROR=red, WARN=yellow bright, INFO=cyan bright, DEBUG=green, TRACE=white}}] %minecraftFormatting{%msg}%n", true, false, false);

        protected GUIAppender() {
            super("GUIAppender", null, null, false, Property.EMPTY_ARRAY);
            ((Logger)LogManager.getRootLogger()).addAppender(this);
        }

        @Override
        public void append(LogEvent event) {
            StringBuilder formatted = new StringBuilder();
            for (PatternFormatter formatter : FORMATTERS) {
                formatter.format(event, formatted);
            }
            GeyserStandaloneGUI.this.appendConsole(formatted.toString());
        }
    }
}

