/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone.gui;

import java.awt.Color;
import java.util.regex.Pattern;

public enum ANSIColor {
    BLACK("(0;)?30(0;)?m", Color.getHSBColor(0.0f, 0.0f, 0.0f)),
    RED("(0;)?31(0;)?m", Color.getHSBColor(0.0f, 1.0f, 0.502f)),
    GREEN("(0;)?32(0;)?m", Color.getHSBColor(0.333f, 1.0f, 0.502f)),
    YELLOW("(0;)?33(0;)?m", Color.getHSBColor(0.167f, 1.0f, 0.502f)),
    BLUE("(0;)?34(0;)?m", Color.getHSBColor(0.667f, 1.0f, 0.502f)),
    MAGENTA("(0;)?35(0;)?m", Color.getHSBColor(0.833f, 1.0f, 0.502f)),
    CYAN("(0;)?36(0;)?m", Color.getHSBColor(0.5f, 1.0f, 0.502f)),
    WHITE("(0;)?37(0;)?m", Color.getHSBColor(0.0f, 0.0f, 0.753f)),
    B_BLACK("(1;30|30;1)m", Color.getHSBColor(0.0f, 0.0f, 0.502f)),
    B_RED("(1;31|31;1)m", Color.getHSBColor(0.0f, 1.0f, 1.0f)),
    B_GREEN("(1;32|32;1)m", Color.getHSBColor(0.333f, 1.0f, 1.0f)),
    B_YELLOW("(1;33|33;1)m", Color.getHSBColor(0.167f, 1.0f, 1.0f)),
    B_BLUE("(1;34|34;1)m", Color.getHSBColor(0.667f, 1.0f, 1.0f)),
    B_MAGENTA("(1;35|35;1)m", Color.getHSBColor(0.833f, 1.0f, 1.0f)),
    B_CYAN("(1;36|36;1)m", Color.getHSBColor(0.5f, 1.0f, 1.0f)),
    B_WHITE("(1;37|37;1)m", Color.getHSBColor(0.0f, 0.0f, 1.0f)),
    RESET("0m", Color.getHSBColor(0.0f, 0.0f, 1.0f));

    private static final ANSIColor[] VALUES;
    private static final String PREFIX;
    private final String ANSICode;
    private final Color color;

    private ANSIColor(String ANSICode, Color color) {
        this.ANSICode = ANSICode;
        this.color = color;
    }

    public static ANSIColor fromANSI(String code) {
        for (ANSIColor value : VALUES) {
            if (!code.matches(PREFIX + value.ANSICode)) continue;
            return value;
        }
        return B_WHITE;
    }

    public Color getColor() {
        return this.color;
    }

    static {
        VALUES = ANSIColor.values();
        PREFIX = Pattern.quote("\u001b[");
    }
}

