/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.predicate.context.item.ChargedProjectile;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.custom.impl.predicates.GeyserChargedProjectile;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.CustomModelData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public record GeyserItemPredicateContext(java.util.function.Supplier<Identifier> dimensionSupplier, int count, java.util.function.Supplier<Integer> maxStackSizeSupplier, java.util.function.Supplier<Integer> damageSupplier, java.util.function.Supplier<Integer> maxDamageSupplier, java.util.function.Supplier<Boolean> fishingRodCastSupplier, java.util.function.Supplier<Boolean> unbreakableSupplier, java.util.function.Supplier<Integer> bundleFullnessSupplier, java.util.function.Supplier<Identifier> trimMaterialSupplier, java.util.function.Supplier<List<ChargedProjectile>> chargedProjectilesSupplier, java.util.function.Supplier<List<Identifier>> componentsSupplier, java.util.function.Supplier<List<Boolean>> customModelDataFlagsSupplier, java.util.function.Supplier<List<String>> customModelDataStringsSupplier, java.util.function.Supplier<List<Float>> customModelDataFloatsSupplier) implements ItemPredicateContext
{
    private static final CustomModelData EMPTY_CUSTOM_MODEL_DATA = new CustomModelData(List.of(), List.of(), List.of(), List.of());

    @Override
    public Identifier dimension() {
        return this.dimensionSupplier.get();
    }

    @Override
    public int maxStackSize() {
        return this.maxStackSizeSupplier.get();
    }

    @Override
    public int damage() {
        return this.damageSupplier.get();
    }

    @Override
    public int maxDamage() {
        return this.maxDamageSupplier.get();
    }

    @Override
    public boolean hasFishingRodCast() {
        return this.fishingRodCastSupplier.get();
    }

    @Override
    public boolean unbreakable() {
        return this.unbreakableSupplier.get();
    }

    @Override
    public int bundleFullness() {
        return this.bundleFullnessSupplier.get();
    }

    @Override
    public @Nullable Identifier trimMaterial() {
        return this.trimMaterialSupplier.get();
    }

    @Override
    public List<ChargedProjectile> chargedProjectiles() {
        return this.chargedProjectilesSupplier.get();
    }

    @Override
    public List<Identifier> components() {
        return this.componentsSupplier.get();
    }

    @Override
    public boolean customModelDataFlag(int index) {
        return this.getCustomBoolean(index);
    }

    @Override
    public String customModelDataString(int index) {
        return GeyserItemPredicateContext.getSafeCustomModelData(this.customModelDataStringsSupplier.get(), index);
    }

    @Override
    public float customModelDataFloat(int index) {
        return this.getCustomFloat(index);
    }

    private boolean getCustomBoolean(int index) {
        Boolean b = GeyserItemPredicateContext.getSafeCustomModelData(this.customModelDataFlagsSupplier.get(), index);
        return b != null && b != false;
    }

    private float getCustomFloat(int index) {
        Float f = GeyserItemPredicateContext.getSafeCustomModelData(this.customModelDataFloatsSupplier.get(), index);
        return f == null ? 0.0f : f.floatValue();
    }

    private static <T> T getSafeCustomModelData(List<T> data, int index) {
        if (index < 0) {
            return null;
        }
        if (index < data.size()) {
            return data.get(index);
        }
        return null;
    }

    public static ItemPredicateContext create(GeyserSession session, int stackSize, DataComponents components) {
        Supplier<Identifier> dimension = Suppliers.memoize(() -> MinecraftKey.keyToIdentifier(JavaRegistries.DIMENSION_TYPE.key(session, session.getDimensionType())));
        Supplier<Integer> maxStackSize = Suppliers.memoize(() -> components.getOrDefault(DataComponentTypes.MAX_STACK_SIZE, 64));
        Supplier<Integer> damage = Suppliers.memoize(() -> components.getOrDefault(DataComponentTypes.DAMAGE, 0));
        Supplier<Integer> maxDamage = Suppliers.memoize(() -> components.getOrDefault(DataComponentTypes.MAX_DAMAGE, 0));
        Supplier<Boolean> fishingRodCast = Suppliers.memoize(session::hasFishingRodCast);
        Supplier<Boolean> unbreakable = Suppliers.memoize(() -> components.get(DataComponentTypes.UNBREAKABLE) != null);
        Supplier<Integer> bundleFullness = Suppliers.memoize(() -> {
            List<ItemStack> bundleStacks = components.get(DataComponentTypes.BUNDLE_CONTENTS);
            int fullness = 0;
            if (bundleStacks != null) {
                for (ItemStack stack : bundleStacks) {
                    fullness += stack.getAmount();
                }
            }
            return fullness;
        });
        Supplier<Identifier> trimMaterial = Suppliers.memoize(() -> {
            ArmorTrim trim = components.get(DataComponentTypes.TRIM);
            if (trim != null && !trim.material().isCustom()) {
                return MinecraftKey.keyToIdentifier(JavaRegistries.TRIM_MATERIAL.key(session, trim.material().id()).key());
            }
            return null;
        });
        Supplier<List<ChargedProjectile>> chargedProjectiles = Suppliers.memoize(() -> components.getOrDefault(DataComponentTypes.CHARGED_PROJECTILES, List.of()).stream().map(GeyserItemPredicateContext::stackToProjectile).toList());
        Supplier<List<Identifier>> componentList = Suppliers.memoize(() -> components.getDataComponents().keySet().stream().map(type -> MinecraftKey.keyToIdentifier(type.getKey())).toList());
        Supplier<CustomModelData> customModelData = Suppliers.memoize(() -> components.getOrDefault(DataComponentTypes.CUSTOM_MODEL_DATA, EMPTY_CUSTOM_MODEL_DATA));
        Supplier<List<Boolean>> flags = Suppliers.memoize(() -> ((CustomModelData)customModelData.get()).flags());
        Supplier<List<String>> strings = Suppliers.memoize(() -> ((CustomModelData)customModelData.get()).strings());
        Supplier<List<Float>> floats = Suppliers.memoize(() -> ((CustomModelData)customModelData.get()).floats());
        return new GeyserItemPredicateContext(dimension, stackSize, maxStackSize, damage, maxDamage, fishingRodCast, unbreakable, bundleFullness, trimMaterial, chargedProjectiles, componentList, flags, strings, floats);
    }

    private static ChargedProjectile stackToProjectile(ItemStack stack) {
        return stack.getId() == Items.FIREWORK_ROCKET.javaId() ? new GeyserChargedProjectile(ChargedProjectile.ChargeType.ROCKET, stack.getAmount()) : new GeyserChargedProjectile(ChargedProjectile.ChargeType.ARROW, stack.getAmount());
    }
}

