/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.edu;

import com.google.gson.JsonObject;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.MinecraftEduServicesResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.StepMsaToken;
import net.raphimc.minecraftauth.util.JsonContent;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepEduJWT
extends AbstractStep<StepMsaToken.MsaToken, EduJWT> {
    public static final String MINECRAFT_LOGIN_URL = "https://login.minecrafteduservices.com/v2/signin";
    private final String version;
    private final int buildNumber;
    private final int protocolVersion;

    public StepEduJWT(AbstractStep<?, StepMsaToken.MsaToken> prevStep, String version, int protocolVersion) {
        super("eduJwt", prevStep);
        String[] versionParts = version.split("\\.");
        if (versionParts.length != 3) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        this.version = version;
        this.buildNumber = Integer.parseInt(versionParts[0]) * 10000000 + Integer.parseInt(versionParts[1]) * 100000 + Integer.parseInt(versionParts[2]) * 1000;
        this.protocolVersion = protocolVersion;
    }

    @Override
    protected EduJWT execute(ILogger logger, HttpClient httpClient, StepMsaToken.MsaToken msaToken) throws Exception {
        logger.info(this, "Authenticating with Minecraft Education Services...");
        JsonObject postData = new JsonObject();
        postData.addProperty("accessToken", msaToken.getAccessToken());
        postData.addProperty("build", this.buildNumber);
        postData.addProperty("clientVersion", this.protocolVersion);
        postData.addProperty("displayVersion", this.version);
        postData.addProperty("identityToken", msaToken.getAccessToken());
        postData.addProperty("locale", "en_US");
        postData.addProperty("osVersion", "10.0");
        postData.addProperty("platform", "Windows Desktop Build (Win32)(x64)");
        postData.addProperty("platformCategory", "desktop");
        PostRequest postRequest = new PostRequest(MINECRAFT_LOGIN_URL);
        postRequest.setContent(new JsonContent(postData));
        JsonObject obj = httpClient.execute(postRequest, new MinecraftEduServicesResponseHandler());
        EduJWT eduJwt = new EduJWT(obj.get("response").getAsString(), msaToken);
        logger.info(this, "Got Edu JWT");
        return eduJwt;
    }

    @Override
    public EduJWT fromJson(JsonObject json) {
        StepMsaToken.MsaToken msaToken = this.prevStep != null ? (StepMsaToken.MsaToken)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new EduJWT(json.get("jwt").getAsString(), msaToken);
    }

    @Override
    public JsonObject toJson(EduJWT eduJWT) {
        JsonObject json = new JsonObject();
        json.addProperty("jwt", eduJWT.jwt);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, this.prevStep.toJson(eduJWT.msaToken));
        }
        return json;
    }

    public static final class EduJWT
    extends AbstractStep.StepResult<StepMsaToken.MsaToken> {
        private final String jwt;
        private final StepMsaToken.MsaToken msaToken;

        @Override
        protected StepMsaToken.MsaToken prevResult() {
            return this.msaToken;
        }

        @Override
        public boolean isExpired() {
            return true;
        }

        @Override
        public boolean isExpiredOrOutdated() {
            return true;
        }

        @Generated
        public EduJWT(String jwt, StepMsaToken.MsaToken msaToken) {
            this.jwt = jwt;
            this.msaToken = msaToken;
        }

        @Generated
        public String getJwt() {
            return this.jwt;
        }

        @Generated
        public StepMsaToken.MsaToken getMsaToken() {
            return this.msaToken;
        }

        @Generated
        public String toString() {
            return "StepEduJWT.EduJWT(jwt=" + this.getJwt() + ", msaToken=" + this.getMsaToken() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EduJWT)) {
                return false;
            }
            EduJWT other = (EduJWT)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jwt = this.getJwt();
            String other$jwt = other.getJwt();
            if (this$jwt == null ? other$jwt != null : !this$jwt.equals(other$jwt)) {
                return false;
            }
            StepMsaToken.MsaToken this$msaToken = this.getMsaToken();
            StepMsaToken.MsaToken other$msaToken = other.getMsaToken();
            return !(this$msaToken == null ? other$msaToken != null : !((Object)this$msaToken).equals(other$msaToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EduJWT;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jwt = this.getJwt();
            result = result * 59 + ($jwt == null ? 43 : $jwt.hashCode());
            StepMsaToken.MsaToken $msaToken = this.getMsaToken();
            result = result * 59 + ($msaToken == null ? 43 : ((Object)$msaToken).hashCode());
            return result;
        }
    }
}

