/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.BreakBlockStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.BreakItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CraftItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CustomStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.DropItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.KillEntityStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.KilledByEntityStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.PickupItemStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.Statistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.StatisticCategory;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.UseItemStatistic;

public class ClientboundAwardStatsPacket
implements MinecraftPacket {
    @NonNull
    private final Object2IntMap<Statistic> statistics = new Object2IntOpenHashMap<Statistic>();

    public ClientboundAwardStatsPacket(ByteBuf in) {
        int length = MinecraftTypes.readVarInt(in);
        for (int index = 0; index < length; ++index) {
            StatisticCategory category = MinecraftTypes.readStatisticCategory(in);
            int statisticId = MinecraftTypes.readVarInt(in);
            Statistic statistic = switch (category) {
                default -> throw new IncompatibleClassChangeError();
                case StatisticCategory.BREAK_BLOCK -> new BreakBlockStatistic(statisticId);
                case StatisticCategory.CRAFT_ITEM -> new CraftItemStatistic(statisticId);
                case StatisticCategory.USE_ITEM -> new UseItemStatistic(statisticId);
                case StatisticCategory.BREAK_ITEM -> new BreakItemStatistic(statisticId);
                case StatisticCategory.PICKED_UP_ITEM -> new PickupItemStatistic(statisticId);
                case StatisticCategory.DROP_ITEM -> new DropItemStatistic(statisticId);
                case StatisticCategory.KILL_ENTITY -> new KillEntityStatistic(EntityType.from(statisticId));
                case StatisticCategory.KILLED_BY_ENTITY -> new KilledByEntityStatistic(EntityType.from(statisticId));
                case StatisticCategory.CUSTOM -> CustomStatistic.from(statisticId);
            };
            this.statistics.put(statistic, MinecraftTypes.readVarInt(in));
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.statistics.size());
        for (Object2IntMap.Entry entry : this.statistics.object2IntEntrySet()) {
            int statisticId;
            StatisticCategory category;
            Statistic statistic = (Statistic)entry.getKey();
            if (statistic instanceof BreakBlockStatistic) {
                category = StatisticCategory.BREAK_BLOCK;
                statisticId = ((BreakBlockStatistic)statistic).getId();
            } else if (statistic instanceof CraftItemStatistic) {
                category = StatisticCategory.CRAFT_ITEM;
                statisticId = ((CraftItemStatistic)statistic).getId();
            } else if (statistic instanceof UseItemStatistic) {
                category = StatisticCategory.USE_ITEM;
                statisticId = ((UseItemStatistic)statistic).getId();
            } else if (statistic instanceof BreakItemStatistic) {
                category = StatisticCategory.BREAK_ITEM;
                statisticId = ((BreakItemStatistic)statistic).getId();
            } else if (statistic instanceof PickupItemStatistic) {
                category = StatisticCategory.PICKED_UP_ITEM;
                statisticId = ((PickupItemStatistic)statistic).getId();
            } else if (statistic instanceof DropItemStatistic) {
                category = StatisticCategory.DROP_ITEM;
                statisticId = ((DropItemStatistic)statistic).getId();
            } else if (statistic instanceof KillEntityStatistic) {
                category = StatisticCategory.KILL_ENTITY;
                statisticId = ((KillEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof KilledByEntityStatistic) {
                category = StatisticCategory.KILLED_BY_ENTITY;
                statisticId = ((KilledByEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof CustomStatistic) {
                category = StatisticCategory.CUSTOM;
                statisticId = ((CustomStatistic)statistic).ordinal();
            } else {
                throw new IllegalStateException();
            }
            MinecraftTypes.writeStatisticCategory(out, category);
            MinecraftTypes.writeVarInt(out, statisticId);
            MinecraftTypes.writeVarInt(out, entry.getIntValue());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @NonNull
    public Object2IntMap<Statistic> getStatistics() {
        return this.statistics;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAwardStatsPacket)) {
            return false;
        }
        ClientboundAwardStatsPacket other = (ClientboundAwardStatsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object2IntMap<Statistic> this$statistics = this.getStatistics();
        Object2IntMap<Statistic> other$statistics = other.getStatistics();
        return !(this$statistics == null ? other$statistics != null : !this$statistics.equals(other$statistics));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundAwardStatsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object2IntMap<Statistic> $statistics = this.getStatistics();
        result = result * 59 + ($statistics == null ? 43 : $statistics.hashCode());
        return result;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "ClientboundAwardStatsPacket(statistics=" + String.valueOf(this.getStatistics()) + ")";
    }

    public ClientboundAwardStatsPacket() {
    }
}

