/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.AbstractCommentedConfigurationNode;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.AttributedConfigurationNode;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.ConfigurationOptions;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.util.UnmodifiableCollections;

class AttributedConfigurationNodeImpl
extends AbstractCommentedConfigurationNode<AttributedConfigurationNode, AttributedConfigurationNodeImpl>
implements AttributedConfigurationNode {
    private String tagName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    protected AttributedConfigurationNodeImpl(String tagName, @Nullable Object path, @Nullable AttributedConfigurationNodeImpl parent, ConfigurationOptions options) {
        super(path, parent, options);
        this.tagName = Objects.requireNonNull(tagName);
    }

    protected AttributedConfigurationNodeImpl(String tagName, @Nullable AttributedConfigurationNodeImpl parent, AttributedConfigurationNodeImpl copyOf) {
        super(parent, copyOf);
        this.tagName = Objects.requireNonNull(tagName);
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    @Override
    public AttributedConfigurationNodeImpl tagName(String tagName) {
        if (Objects.requireNonNull(tagName, "tag name").isEmpty()) {
            throw new IllegalArgumentException("Tag name cannot be null/empty");
        }
        this.tagName = tagName;
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl addAttribute(String name, String value) {
        if (Objects.requireNonNull(name, "name").isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attachIfNecessary();
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    @Override
    public AttributedConfigurationNodeImpl attributes(Map<String, String> attributes) {
        for (String name : attributes.keySet()) {
            if (!Objects.requireNonNull(name, "name").isEmpty()) continue;
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attributes.clear();
        if (!attributes.isEmpty()) {
            this.attachIfNecessary();
            this.attributes.putAll(attributes);
        }
        return this;
    }

    @Override
    public Map<String, String> attributes() {
        return UnmodifiableCollections.copyOf(this.attributes);
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public @Nullable String attribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public boolean empty() {
        return super.empty() && this.attributes.isEmpty();
    }

    @Override
    protected AttributedConfigurationNodeImpl createNode(Object path) {
        return new AttributedConfigurationNodeImpl("element", path, this, this.options());
    }

    @Override
    public AttributedConfigurationNode from(ConfigurationNode that) {
        if (that instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode node = (AttributedConfigurationNode)that;
            this.tagName(node.tagName());
            this.attributes((Map)node.attributes());
        }
        return (AttributedConfigurationNode)super.from(that);
    }

    @Override
    public AttributedConfigurationNode mergeFrom(ConfigurationNode other) {
        if (other instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode node = (AttributedConfigurationNode)other;
            this.tagName(node.tagName());
            for (Map.Entry<String, String> attribute : node.attributes().entrySet()) {
                this.addAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        return (AttributedConfigurationNode)super.mergeFrom(other);
    }

    @Override
    protected AttributedConfigurationNodeImpl copy(@Nullable AttributedConfigurationNodeImpl parent) {
        AttributedConfigurationNodeImpl copy = new AttributedConfigurationNodeImpl(this.tagName, parent, this);
        copy.attributes.putAll(this.attributes);
        COMMENT_UPDATER.set(copy, this.comment);
        return copy;
    }

    @Override
    public AttributedConfigurationNodeImpl self() {
        return this;
    }

    @Override
    protected AttributedConfigurationNodeImpl implSelf() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributedConfigurationNodeImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AttributedConfigurationNodeImpl that = (AttributedConfigurationNodeImpl)o;
        return this.tagName.equals(that.tagName) && this.attributes.equals(that.attributes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tagName.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AttributedConfigurationNodeImpl{super=" + super.toString() + ", comment=" + this.comment + ", tagName=" + this.tagName + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

