/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.standard;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.caption.CaptionVariable;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.caption.StandardCaptionKeys;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.component.CommandComponent;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.context.CommandInput;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.exception.parsing.ParserException;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ArgumentParser;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ParserDescriptor;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@API(status=API.Status.STABLE)
public final class BooleanParser<C>
implements ArgumentParser<C, Boolean>,
BlockingSuggestionProvider.Strings<C> {
    private static final List<String> STRICT_LOWER = CommandInput.BOOLEAN_STRICT.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    private static final List<String> LIBERAL_LOWER = CommandInput.BOOLEAN_LIBERAL.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    private final boolean liberal;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Boolean> booleanParser() {
        return BooleanParser.booleanParser(false);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Boolean> booleanParser(boolean liberal) {
        return ParserDescriptor.of(new BooleanParser<C>(liberal), Boolean.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Boolean> booleanComponent() {
        return CommandComponent.builder().parser(BooleanParser.booleanParser());
    }

    public BooleanParser(boolean liberal) {
        this.liberal = liberal;
    }

    @Override
    public @NonNull ArgumentParseResult<Boolean> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidBoolean(this.liberal)) {
            return ArgumentParseResult.failure(new BooleanParseException(commandInput.peekString(), this.liberal, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readBoolean());
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        if (!this.liberal) {
            return STRICT_LOWER;
        }
        return LIBERAL_LOWER;
    }

    @API(status=API.Status.STABLE)
    public static final class BooleanParseException
    extends ParserException {
        private final String input;
        private final boolean liberal;

        public BooleanParseException(@NonNull String input, boolean liberal, @NonNull CommandContext<?> context) {
            super(BooleanParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_BOOLEAN, CaptionVariable.of("input", input));
            this.input = input;
            this.liberal = liberal;
        }

        public @NonNull String input() {
            return this.input;
        }

        public boolean liberal() {
            return this.liberal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BooleanParseException that = (BooleanParseException)o;
            return this.liberal == that.liberal && this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input, this.liberal);
        }
    }
}

