/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.marcono1234.gson.recordadapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;

class ComponentTypeHelper {
    private ComponentTypeHelper() {
    }

    private static Type getUltimateTypeVariableBound(TypeVariable<?> typeVariable) {
        Type current = typeVariable;
        while (current instanceof TypeVariable) {
            TypeVariable<?> typeVar = current;
            current = typeVar.getBounds()[0];
        }
        return current;
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return ComponentTypeHelper.getRawType(arrayType.getGenericComponentType()).arrayType();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return ComponentTypeHelper.getRawType(ComponentTypeHelper.getUltimateTypeVariableBound(typeVariable));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return ComponentTypeHelper.getRawType(wildcard.getUpperBounds()[0]);
        }
        throw new AssertionError((Object)("Unexpected type instance " + type + " of class " + type.getClass().getName()));
    }

    private static Type resolveTypeVariables(Type type, Function<TypeVariable<?>, Type> resolver) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof GenericArrayType) {
            Type newComponentType;
            GenericArrayType arrayType = (GenericArrayType)type;
            Type originalComponentType = arrayType.getGenericComponentType();
            if (originalComponentType.equals(newComponentType = ComponentTypeHelper.resolveTypeVariables(originalComponentType, resolver))) {
                return arrayType;
            }
            return new GenericArrayTypeImpl(newComponentType);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type originalRawType = parameterizedType.getRawType();
            Type newRawType = ComponentTypeHelper.resolveTypeVariables(originalRawType, resolver);
            Type originalOwnerType = parameterizedType.getOwnerType();
            Type newOwnerType = originalOwnerType == null ? null : ComponentTypeHelper.resolveTypeVariables(originalOwnerType, resolver);
            Object[] originalTypeArguments = parameterizedType.getActualTypeArguments();
            Object[] newTypeArguments = new Type[originalTypeArguments.length];
            for (int i = 0; i < originalTypeArguments.length; ++i) {
                newTypeArguments[i] = ComponentTypeHelper.resolveTypeVariables(originalTypeArguments[i], resolver);
            }
            if (originalRawType.equals(newRawType) && Objects.equals(originalOwnerType, newOwnerType) && Arrays.equals(originalTypeArguments, newTypeArguments)) {
                return parameterizedType;
            }
            return new ParameterizedTypeImpl(newRawType, newOwnerType, (Type[])newTypeArguments);
        }
        if (type instanceof WildcardType) {
            int i;
            WildcardType wildcardType = (WildcardType)type;
            Object[] originalLowerBounds = wildcardType.getLowerBounds();
            Object[] newLowerBounds = new Type[originalLowerBounds.length];
            Object[] originalUpperBounds = wildcardType.getUpperBounds();
            Object[] newUpperBounds = new Type[originalUpperBounds.length];
            for (i = 0; i < originalLowerBounds.length; ++i) {
                newLowerBounds[i] = ComponentTypeHelper.resolveTypeVariables(originalLowerBounds[i], resolver);
            }
            for (i = 0; i < originalUpperBounds.length; ++i) {
                newUpperBounds[i] = ComponentTypeHelper.resolveTypeVariables(originalUpperBounds[i], resolver);
            }
            if (Arrays.equals(originalLowerBounds, newLowerBounds) && Arrays.equals(originalUpperBounds, newUpperBounds)) {
                return wildcardType;
            }
            return new WildcardTypeImpl((Type[])newLowerBounds, (Type[])newUpperBounds);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return resolver.apply(typeVariable);
        }
        throw new AssertionError((Object)("Unexpected type instance " + type + " of class " + type.getClass().getName()));
    }

    private static Type resolveTypeVariableRaw(TypeVariable<?> toResolve) {
        Function resolver = new Function<TypeVariable<?>, Type>(){
            private final Set<TypeVariable<?>> visited = new HashSet();

            @Override
            public Type apply(TypeVariable<?> toResolve) {
                Type bound = ComponentTypeHelper.getUltimateTypeVariableBound(toResolve);
                if (this.visited.add(toResolve)) {
                    return ComponentTypeHelper.resolveTypeVariables(bound, this);
                }
                return ComponentTypeHelper.getRawType(bound);
            }
        };
        return ComponentTypeHelper.resolveTypeVariables(toResolve, resolver);
    }

    private static Map<TypeVariable<?>, Type> getResolvedTypeArguments(TypeVariable<?>[] typeVariables, Type type) {
        final HashMap resolvedTypeArguments = new HashMap();
        if (type instanceof Class) {
            for (TypeVariable<?> typeVariable : typeVariables) {
                resolvedTypeArguments.put(typeVariable, ComponentTypeHelper.resolveTypeVariableRaw(typeVariable));
            }
            return resolvedTypeArguments;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            LinkedHashSet<TypeVariable> wildcardsToResolve = new LinkedHashSet<TypeVariable>();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                TypeVariable typeVariable = typeVariables[i];
                if (typeArgument instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArgument;
                    Type upperBound = wildcardType.getUpperBounds()[0];
                    if (upperBound != Object.class) {
                        resolvedTypeArguments.put(typeVariable, ComponentTypeHelper.resolveTypeVariables(upperBound, toResolve -> ComponentTypeHelper.resolveTypeVariableRaw(toResolve)));
                        continue;
                    }
                    wildcardsToResolve.add(typeVariable);
                    continue;
                }
                resolvedTypeArguments.put(typeVariable, ComponentTypeHelper.resolveTypeVariables(typeArgument, toResolve -> ComponentTypeHelper.resolveTypeVariableRaw(toResolve)));
            }
            Function wildcardResolver = new Function<TypeVariable<?>, Type>(){

                @Override
                public Type apply(TypeVariable<?> toResolve) {
                    if (resolvedTypeArguments.containsKey(toResolve)) {
                        Type resolved = (Type)resolvedTypeArguments.get(toResolve);
                        if (resolved == null) {
                            return ComponentTypeHelper.getRawType(toResolve);
                        }
                        return resolved;
                    }
                    resolvedTypeArguments.put(toResolve, null);
                    Type bound = toResolve.getBounds()[0];
                    Type resolved = ComponentTypeHelper.resolveTypeVariables(bound, this);
                    resolvedTypeArguments.put(toResolve, resolved);
                    return resolved;
                }
            };
            for (TypeVariable typeVariable : wildcardsToResolve) {
                if (resolvedTypeArguments.containsKey(typeVariable)) continue;
                wildcardResolver.apply(typeVariable);
            }
            return resolvedTypeArguments;
        }
        throw new AssertionError((Object)("Unexpected type instance " + type + " of class " + type.getClass().getName()));
    }

    public static Type[] resolveComponentTypes(TypeToken<?> recordContext, Type[] componentTypes) {
        TypeVariable<Class<T>>[] typeVariables = recordContext.getRawType().getTypeParameters();
        if (typeVariables.length == 0) {
            return componentTypes;
        }
        Type recordContextType = recordContext.getType();
        if (recordContextType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)recordContextType;
            recordContextType = wildcard.getUpperBounds()[0];
        }
        if (recordContextType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)recordContextType;
            recordContextType = ComponentTypeHelper.getUltimateTypeVariableBound(typeVariable);
        }
        Map<TypeVariable<?>, Type> typeArguments = ComponentTypeHelper.getResolvedTypeArguments(typeVariables, recordContextType);
        Type[] resolvedComponentTypes = new Type[componentTypes.length];
        for (int i = 0; i < resolvedComponentTypes.length; ++i) {
            resolvedComponentTypes[i] = ComponentTypeHelper.resolveTypeVariables(componentTypes[i], typeArguments::get);
        }
        return resolvedComponentTypes;
    }

    static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = Objects.requireNonNull(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof GenericArrayType) {
                GenericArrayType other = (GenericArrayType)obj;
                return Objects.equals(this.componentType, other.getGenericComponentType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.componentType);
        }

        public String toString() {
            return this.componentType.getTypeName() + "[]";
        }
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type ownerType;
        private final Type[] typeArguments;

        ParameterizedTypeImpl(Type rawType, Type ownerType, Type[] typeArguments) {
            this.rawType = Objects.requireNonNull(rawType);
            this.ownerType = ownerType;
            this.typeArguments = (Type[])typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ParameterizedType) {
                ParameterizedType other = (ParameterizedType)obj;
                return Objects.equals(this.ownerType, other.getOwnerType()) && Objects.equals(this.rawType, other.getRawType()) && Arrays.equals(this.typeArguments, other.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                sb.append(this.ownerType.getTypeName()).append('$');
                Type[] typeArray = this.rawType;
                if (typeArray instanceof Class) {
                    Class c = (Class)typeArray;
                    sb.append(c.getSimpleName());
                } else {
                    sb.append(this.rawType.getTypeName());
                }
            } else {
                sb.append(this.rawType.getTypeName());
            }
            StringJoiner typeArgumentsJoiner = new StringJoiner(", ", "<", ">");
            typeArgumentsJoiner.setEmptyValue("");
            for (Type typeArgument : this.typeArguments) {
                typeArgumentsJoiner.add(typeArgument.getTypeName());
            }
            sb.append(typeArgumentsJoiner.toString());
            return sb.toString();
        }
    }

    static class WildcardTypeImpl
    implements WildcardType {
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            lowerBounds = (Type[])lowerBounds.clone();
            upperBounds = (Type[])upperBounds.clone();
            if (upperBounds.length == 0) {
                throw new IllegalArgumentException("At least Object is required as upper bound");
            }
            if (lowerBounds.length > 0 && (upperBounds.length != 1 || upperBounds[0] != Object.class)) {
                throw new IllegalArgumentException("Malformed bounds: lower=" + Arrays.toString(lowerBounds) + ", upper=" + Arrays.toString(upperBounds));
            }
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WildcardType) {
                WildcardType other = (WildcardType)obj;
                return Arrays.equals(this.lowerBounds, other.getLowerBounds()) && Arrays.equals(this.upperBounds, other.getUpperBounds());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
        }

        public String toString() {
            Type[] bounds;
            StringBuilder sb = new StringBuilder();
            if (this.lowerBounds.length > 0) {
                sb.append("? super ");
                bounds = this.lowerBounds;
            } else {
                if (this.upperBounds.length == 1 && this.upperBounds[0] == Object.class) {
                    return "?";
                }
                sb.append("? extends ");
                bounds = this.upperBounds;
            }
            StringJoiner boundsJoiner = new StringJoiner(" & ");
            for (Type bound : bounds) {
                boundsJoiner.add(bound.getTypeName());
            }
            sb.append(boundsJoiner.toString());
            return sb.toString();
        }
    }
}

