/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import java.util.Collections;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BedrockChunkWantsBlockEntityTag;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;

public class LecternBlock
extends Block
implements BedrockChunkWantsBlockEntityTag {
    public LecternBlock(String javaIdentifier, Block.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public NbtMap createTag(GeyserSession session, Vector3i position, BlockState blockState) {
        return LecternBlock.getBaseLecternTag(position, blockState.getValue(Properties.HAS_BOOK));
    }

    @Override
    public void updateBlock(GeyserSession session, BlockState state, Vector3i position) {
        super.updateBlock(session, state, position);
        boolean hasBook = state.getValue(Properties.HAS_BOOK);
        BlockEntityUtils.updateBlockEntity(session, LecternBlock.getBaseLecternTag(position, hasBook), position);
    }

    public static NbtMap getBaseLecternTag(Vector3i position, boolean hasBook) {
        if (hasBook) {
            return LecternBlock.getBaseLecternTag(position, 1).putCompound("book", NbtMap.builder().putByte("Count", (byte)1).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book").putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, Collections.singletonList(NbtMap.builder().putString("photoname", "").putString("text", "").build())).build()).build()).build();
        }
        return LecternBlock.getBaseLecternTag(position, 0).build();
    }

    public static NbtMapBuilder getBaseLecternTag(Vector3i position, int pages) {
        NbtMapBuilder builder = BlockEntityTranslator.getConstantBedrockTag("Lectern", position);
        builder.putBoolean("isMovable", true);
        if (pages != 0) {
            builder.putByte("hasBook", (byte)1);
            builder.putInt("totalPages", 1);
        }
        return builder;
    }
}

