/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import org.checkerframework.common.value.qual.IntRange;
import org.geysermc.geyser.api.item.custom.v2.component.java.AttackRange;

public record AttackRangeImpl(@IntRange(from=0L, to=64L) float minReach, @IntRange(from=0L, to=64L) float maxReach, @IntRange(from=0L, to=64L) float minCreativeReach, @IntRange(from=0L, to=64L) float maxCreativeReach, @IntRange(from=0L, to=1L) float hitboxMargin) implements AttackRange
{
    public static final AttackRange DEFAULT = new Builder().build();

    public static class Builder
    implements AttackRange.Builder {
        private float minReach = 0.0f;
        private float maxReach = 3.0f;
        private float minCreativeReach = 0.0f;
        private float maxCreativeReach = 5.0f;
        private float hitboxMargin = 0.3f;

        @Override
        public Builder minReach(@IntRange(from=0L, to=64L) float minReach) {
            this.minReach = Builder.validateReachArgument(minReach);
            return this;
        }

        @Override
        public Builder maxReach(@IntRange(from=0L, to=64L) float maxReach) {
            this.maxReach = Builder.validateReachArgument(maxReach);
            return this;
        }

        @Override
        public Builder minCreativeReach(@IntRange(from=0L, to=64L) float minCreativeReach) {
            this.minCreativeReach = Builder.validateReachArgument(minCreativeReach);
            return this;
        }

        @Override
        public Builder maxCreativeReach(@IntRange(from=0L, to=64L) float maxCreativeReach) {
            this.maxCreativeReach = Builder.validateReachArgument(maxCreativeReach);
            return this;
        }

        @Override
        public Builder hitboxMargin(@IntRange(from=0L, to=1L) float hitboxMargin) {
            if (hitboxMargin < 0.0f || hitboxMargin > 1.0f) {
                throw new IllegalArgumentException("hitbox margin must be between 0 and 1 (inclusive)");
            }
            this.hitboxMargin = hitboxMargin;
            return this;
        }

        @Override
        public AttackRange build() {
            return new AttackRangeImpl(this.minReach, this.maxReach, this.minCreativeReach, this.maxCreativeReach, this.hitboxMargin);
        }

        private static float validateReachArgument(float reach) {
            if (reach < 0.0f || reach > 64.0f) {
                throw new IllegalArgumentException("reach must be between 0 and 64 (inclusive)");
            }
            return reach;
        }
    }
}

