/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.adapters.paper.v774;

import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.geysermc.geyser.adapters.paper.PaperWorldAdapter;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;

public class WorldAdapter_v774
extends PaperWorldAdapter {
    @Override
    public int getBlockAt(World world, int x, int y, int z) {
        LevelChunkSection section;
        if (y < world.getMinHeight()) {
            return 0;
        }
        LevelChunk chunk = ((CraftWorld)world).getHandle().getChunkIfLoaded(x >> 4, z >> 4);
        if (chunk == null) {
            return 0;
        }
        int worldOffset = world.getMinHeight() >> 4;
        int chunkOffset = (y >> 4) - worldOffset;
        if (chunkOffset < chunk.getSections().length && (section = chunk.getSections()[chunkOffset]) != null && !section.hasOnlyAir()) {
            return Block.getId((BlockState)section.getBlockState(x & 0xF, y & 0xF, z & 0xF));
        }
        return 0;
    }

    @Override
    public IntList getAllBlockStates() {
        IntArrayList blockStates = new IntArrayList();
        for (BlockState block : Block.BLOCK_STATE_REGISTRY) {
            blockStates.add(Block.getId((BlockState)block));
        }
        return blockStates;
    }

    @Override
    public String[] getBiomeSuggestions(boolean tags) {
        Registry registry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME);
        if (!tags) {
            return (String[])this.getBiomes((Registry<Biome>)registry).toArray(String[]::new);
        }
        ArrayList<String> keys = new ArrayList<String>(registry.getTags().map(tag -> "#" + String.valueOf(tag.key().location())).toList());
        keys.addAll(this.getBiomes((Registry<Biome>)registry).toList());
        return keys.toArray(new String[0]);
    }

    private Stream<String> getBiomes(Registry<Biome> registry) {
        return registry.keySet().stream().map(Identifier::toString);
    }
}

