/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.model;

import com.google.gson.JsonObject;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;

public final class MsaToken
implements Expirable {
    private final long expireTimeMs;
    private final String accessToken;
    private final String refreshToken;

    public static MsaToken fromJson(JsonObject json) {
        return MsaToken.fromJson(new GsonObject(json));
    }

    public static MsaToken fromJson(GsonObject json) {
        return new MsaToken(json.reqLong("expireTimeMs"), json.reqString("accessToken"), json.getString("refreshToken", null));
    }

    public static JsonObject toJson(MsaToken token) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.addProperty("expireTimeMs", (Number)token.expireTimeMs);
        json.addProperty("accessToken", token.accessToken);
        json.addProperty("refreshToken", token.refreshToken);
        return json;
    }

    @Generated
    public MsaToken(long expireTimeMs, String accessToken, String refreshToken) {
        this.expireTimeMs = expireTimeMs;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    @Override
    @Generated
    public long getExpireTimeMs() {
        return this.expireTimeMs;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsaToken)) {
            return false;
        }
        MsaToken other = (MsaToken)o;
        if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expireTimeMs = this.getExpireTimeMs();
        result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MsaToken(expireTimeMs=" + this.getExpireTimeMs() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ")";
    }
}

