/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.java.request;

import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.time.Instant;
import java.util.Base64;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.java.model.MinecraftPlayerCertificates;
import net.raphimc.minecraftauth.java.model.MinecraftToken;
import net.raphimc.minecraftauth.java.responsehandler.MinecraftServicesResponseHandler;
import net.raphimc.minecraftauth.util.CryptUtil;

public class MinecraftPlayerCertificatesRequest
extends PostRequest
implements MinecraftServicesResponseHandler<MinecraftPlayerCertificates> {
    public MinecraftPlayerCertificatesRequest(MinecraftToken token) throws MalformedURLException {
        super("https://api.minecraftservices.com/player/certificates");
        this.setHeader("Authorization", token.getAuthorizationHeader());
    }

    @Override
    public MinecraftPlayerCertificates handle(HttpResponse response, GsonObject json) throws IOException {
        GsonObject keyPairJson = json.reqObject("keyPair");
        return new MinecraftPlayerCertificates(Instant.parse(json.reqString("expiresAt")).toEpochMilli(), new KeyPair(CryptUtil.rsaPublicKeyFromBytes(Base64.getMimeDecoder().decode(keyPairJson.reqString("publicKey").replace("-----BEGIN RSA PUBLIC KEY-----", "").replace("-----END RSA PUBLIC KEY-----", ""))), CryptUtil.rsaPrivateKeyFromBytes(Base64.getMimeDecoder().decode(keyPairJson.reqString("privateKey").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "")))), Base64.getDecoder().decode(json.reqString("publicKeySignatureV2")), json.optString("publicKeySignature").map(Base64.getDecoder()::decode).orElse(null));
    }
}

