/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.cloudburstmc.protocol.bedrock.codec.v819.Bedrock_v819;
import org.cloudburstmc.protocol.bedrock.codec.v827.Bedrock_v827;
import org.cloudburstmc.protocol.bedrock.codec.v844.Bedrock_v844;
import org.cloudburstmc.protocol.bedrock.codec.v859.Bedrock_v859;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemCategory;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemGroup;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;
import org.cloudburstmc.protocol.common.Definition;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.NonVanillaCustomItemDefinition;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.custom.impl.predicates.GeyserRangeDispatchPredicate;
import org.geysermc.geyser.item.exception.InvalidItemComponentsException;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.populator.CreativeItemRegistryPopulator;
import org.geysermc.geyser.registry.populator.CustomItemRegistryPopulator;
import org.geysermc.geyser.registry.populator.conversion.Conversion844_827;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.geyser.registry.type.PaletteItem;
import org.geysermc.geyser.util.MinecraftKey;

public class ItemRegistryPopulator {
    public static void populate() {
        Map<String, GeyserMappingItem> items;
        HashMap<Item, Item> eightTwoSevenFallbacks = new HashMap<Item, Item>();
        eightTwoSevenFallbacks.put(Items.ACACIA_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.BAMBOO_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.BIRCH_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.CHERRY_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.CRIMSON_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.DARK_OAK_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.JUNGLE_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.MANGROVE_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.OAK_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.PALE_OAK_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.SPRUCE_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.WARPED_SHELF, Items.CHISELED_BOOKSHELF);
        eightTwoSevenFallbacks.put(Items.COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.EXPOSED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.WEATHERED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.OXIDIZED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.WAXED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.WAXED_EXPOSED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.WAXED_WEATHERED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.WAXED_OXIDIZED_COPPER_BARS, Items.IRON_BARS);
        eightTwoSevenFallbacks.put(Items.COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.EXPOSED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.WEATHERED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.OXIDIZED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.WAXED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.WAXED_EXPOSED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.WAXED_WEATHERED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.WAXED_OXIDIZED_COPPER_GOLEM_STATUE, Items.ARMOR_STAND);
        eightTwoSevenFallbacks.put(Items.COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.EXPOSED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.WEATHERED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.OXIDIZED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.WAXED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.WAXED_EXPOSED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.WAXED_WEATHERED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.WAXED_OXIDIZED_COPPER_LANTERN, Items.LANTERN);
        eightTwoSevenFallbacks.put(Items.EXPOSED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.WEATHERED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.OXIDIZED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.WAXED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.WAXED_EXPOSED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.WAXED_WEATHERED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.WAXED_OXIDIZED_LIGHTNING_ROD, Items.LIGHTNING_ROD);
        eightTwoSevenFallbacks.put(Items.COPPER_TORCH, Items.TORCH);
        eightTwoSevenFallbacks.put(Items.COPPER_HORSE_ARMOR, Items.LEATHER_HORSE_ARMOR);
        HashMap<Item, Item> eightOneNineFallbacks = new HashMap<Item, Item>(eightTwoSevenFallbacks);
        eightOneNineFallbacks.put(Items.COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.EXPOSED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.WEATHERED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.OXIDIZED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.WAXED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.WAXED_EXPOSED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.WAXED_WEATHERED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.WAXED_OXIDIZED_COPPER_CHEST, Items.CHEST);
        eightOneNineFallbacks.put(Items.COPPER_HELMET, Items.LEATHER_HELMET);
        eightOneNineFallbacks.put(Items.COPPER_CHESTPLATE, Items.LEATHER_CHESTPLATE);
        eightOneNineFallbacks.put(Items.COPPER_LEGGINGS, Items.LEATHER_LEGGINGS);
        eightOneNineFallbacks.put(Items.COPPER_BOOTS, Items.LEATHER_BOOTS);
        eightOneNineFallbacks.put(Items.COPPER_NUGGET, Items.IRON_NUGGET);
        eightOneNineFallbacks.put(Items.COPPER_SWORD, Items.STONE_SWORD);
        eightOneNineFallbacks.put(Items.COPPER_PICKAXE, Items.STONE_PICKAXE);
        eightOneNineFallbacks.put(Items.COPPER_SHOVEL, Items.STONE_SHOVEL);
        eightOneNineFallbacks.put(Items.COPPER_AXE, Items.STONE_AXE);
        eightOneNineFallbacks.put(Items.COPPER_HOE, Items.STONE_HOE);
        eightOneNineFallbacks.put(Items.COPPER_GOLEM_SPAWN_EGG, Items.IRON_GOLEM_SPAWN_EGG);
        HashMap<Item, Item> eightOneEightFallbacks = new HashMap<Item, Item>(eightOneNineFallbacks);
        eightOneEightFallbacks.put(Items.MUSIC_DISC_LAVA_CHICKEN, Items.MUSIC_DISC_CHIRP);
        ArrayList<PaletteVersion> paletteVersions = new ArrayList<PaletteVersion>(4);
        paletteVersions.add(new PaletteVersion("1_21_90", Bedrock_v818.CODEC.getProtocolVersion(), eightOneEightFallbacks, Conversion844_827::remapItem));
        paletteVersions.add(new PaletteVersion("1_21_93", Bedrock_v819.CODEC.getProtocolVersion(), eightOneNineFallbacks, Conversion844_827::remapItem));
        paletteVersions.add(new PaletteVersion("1_21_100", Bedrock_v827.CODEC.getProtocolVersion(), eightTwoSevenFallbacks, Conversion844_827::remapItem));
        paletteVersions.add(new PaletteVersion("1_21_110", Bedrock_v844.CODEC.getProtocolVersion()));
        paletteVersions.add(new PaletteVersion("1_21_120", Bedrock_v859.CODEC.getProtocolVersion()));
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        TypeReference<Map<String, GeyserMappingItem>> mappingItemsType = new TypeReference<Map<String, GeyserMappingItem>>(){};
        try (InputStream stream = bootstrap.getResourceOrThrow("mappings/items.json");){
            items = GeyserImpl.JSON_MAPPER.readValue(stream, mappingItemsType);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java runtime item IDs", e);
        }
        boolean customItemsAllowed = bootstrap.getGeyserConfig().isAddNonBedrockItems();
        ListMultimap customItems = MultimapBuilder.hashKeys().arrayListValues().build();
        ListMultimap nonVanillaCustomItems = MultimapBuilder.hashKeys().arrayListValues().build();
        if (customItemsAllowed) {
            CustomItemRegistryPopulator.populate(items, (Multimap<Identifier, CustomItemDefinition>)customItems, (Multimap<Identifier, NonVanillaCustomItemDefinition>)nonVanillaCustomItems);
        }
        boolean firstMappingsPass = true;
        for (PaletteVersion palette : paletteVersions) {
            CreativeItemData creativeItemData;
            ItemDefinition lightBlock;
            NbtMap vanillaComponents;
            List<PaletteItem> itemEntries;
            TypeReference<List<PaletteItem>> paletteEntriesType = new TypeReference<List<PaletteItem>>(){};
            try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/runtime_item_states.%s.json", palette.version()));){
                itemEntries = GeyserImpl.JSON_MAPPER.readValue(stream, paletteEntriesType);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            try (InputStream stream = bootstrap.getResourceOrThrow("bedrock/item_components.%s.nbt".formatted(palette.version()));){
                vanillaComponents = (NbtMap)NbtUtils.createGZIPReader(stream, true, true).readTag();
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock item components", e);
            }
            int nextFreeBedrockId = 0;
            Int2ObjectOpenHashMap<ItemDefinition> registry = new Int2ObjectOpenHashMap<ItemDefinition>();
            Object2ObjectLinkedOpenHashMap<String, ItemDefinition> definitions = new Object2ObjectLinkedOpenHashMap<String, ItemDefinition>();
            for (PaletteItem entry : itemEntries) {
                NbtMap components;
                int id = entry.getId();
                if (id >= nextFreeBedrockId) {
                    nextFreeBedrockId = id + 1;
                }
                if ((components = vanillaComponents.getCompound(entry.getName())) == null && entry.isComponentBased()) {
                    if (!entry.getName().contains("lava_chicken")) {
                        throw new RuntimeException("Could not find vanilla components for vanilla component based item! " + entry.getName());
                    }
                    components = NbtMap.EMPTY;
                }
                SimpleItemDefinition definition = new SimpleItemDefinition(entry.getName().intern(), id, ItemVersion.from(entry.getVersion()), entry.isComponentBased(), components);
                definitions.put(entry.getName(), definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
            }
            Object2ObjectOpenHashMap bedrockBlockIdOverrides = new Object2ObjectOpenHashMap();
            Object2IntOpenHashMap blacklistedIdentifiers = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap<CustomBlockData, ItemDefinition> customBlockItemDefinitions = new Object2ObjectOpenHashMap<CustomBlockData, ItemDefinition>();
            ObjectArrayList<ItemDefinition> buckets = new ObjectArrayList<ItemDefinition>();
            ObjectArrayList mappings = new ObjectArrayList();
            Object2ObjectOpenHashMap<Item, ItemMapping> javaItemToMapping = new Object2ObjectOpenHashMap<Item, ItemMapping>();
            ArrayList<CreativeItemData> creativeItems = new ArrayList<CreativeItemData>();
            ObjectOpenHashSet noBlockDefinitions = new ObjectOpenHashSet();
            noBlockDefinitions.add("minecraft:structure_block");
            noBlockDefinitions.add("minecraft:structure_void");
            AtomicInteger creativeNetId = new AtomicInteger();
            CreativeItemRegistryPopulator.populate(palette, definitions, items, (itemBuilder, groupId) -> {
                ItemData item = itemBuilder.netId(creativeNetId.incrementAndGet()).build();
                creativeItems.add(new CreativeItemData(item, item.getNetId(), (int)groupId));
                if (item.getBlockDefinition() != null) {
                    String identifier = item.getDefinition().getIdentifier();
                    if (!blacklistedIdentifiers.containsKey(identifier)) {
                        if (bedrockBlockIdOverrides.containsKey(identifier)) {
                            bedrockBlockIdOverrides.remove(identifier);
                            blacklistedIdentifiers.put(identifier, item.getBlockDefinition().getRuntimeId());
                        } else {
                            bedrockBlockIdOverrides.put(identifier, item.getBlockDefinition());
                        }
                    }
                } else {
                    noBlockDefinitions.add(item.getDefinition().getIdentifier());
                }
            });
            ObjectArrayList<CreativeItemGroup> creativeItemGroups = new ObjectArrayList<CreativeItemGroup>();
            Object2IntOpenHashMap<String> creativeGroupIds = new Object2IntOpenHashMap<String>();
            Object2IntOpenHashMap<CreativeItemCategory> lastCreativeGroupIds = new Object2IntOpenHashMap<CreativeItemCategory>();
            CreativeItemRegistryPopulator.readCreativeItemGroups(palette, creativeItems, creativeItemGroups, creativeGroupIds, lastCreativeGroupIds);
            BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
            ObjectOpenHashSet<Item> javaOnlyItems = new ObjectOpenHashSet<Item>();
            Collections.addAll(javaOnlyItems, Items.SPECTRAL_ARROW, Items.DEBUG_STICK, Items.KNOWLEDGE_BOOK, Items.TIPPED_ARROW);
            if (!customItemsAllowed) {
                javaOnlyItems.add(Items.FURNACE_MINECART);
            }
            javaOnlyItems.addAll(palette.javaOnlyItems().keySet());
            Int2ObjectOpenHashMap<String> customIdMappings = new Int2ObjectOpenHashMap<String>();
            ObjectOpenHashSet registeredCustomItems = new ObjectOpenHashSet();
            for (Map.Entry<String, GeyserMappingItem> entry : items.entrySet()) {
                SortedSetMultimap customItemDefinitions;
                Object bedrockBlock;
                ItemDefinition definition;
                String bedrockIdentifier;
                GeyserMappingItem mappingItem;
                Item javaItem;
                block71: {
                    Object blockTag;
                    int aValidBedrockBlockId;
                    CustomBlockData customBlockData;
                    Definition customBlockItemOverride;
                    Integer firstBlockRuntimeId;
                    block73: {
                        block72: {
                            javaItem = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(entry.getKey());
                            if (javaItem == null) {
                                throw new RuntimeException("Extra item in mappings? " + entry.getKey());
                            }
                            Item replacementItem = palette.javaOnlyItems().get(javaItem);
                            mappingItem = replacementItem != null ? items.get(replacementItem.javaIdentifier()) : palette.remapper().remap(javaItem, entry.getValue());
                            if (customItemsAllowed && javaItem == Items.FURNACE_MINECART) {
                                mappings.add(null);
                                continue;
                            }
                            bedrockIdentifier = mappingItem.getBedrockIdentifier();
                            definition = (ItemDefinition)definitions.get(bedrockIdentifier);
                            if (definition == null) {
                                throw new RuntimeException("Missing Bedrock ItemDefinition in version " + palette.version() + " for mapping: " + String.valueOf(mappingItem));
                            }
                            bedrockBlock = null;
                            firstBlockRuntimeId = entry.getValue().getFirstBlockRuntimeId();
                            customBlockItemOverride = null;
                            if (firstBlockRuntimeId == null) break block71;
                            BlockDefinition blockOverride = (BlockDefinition)bedrockBlockIdOverrides.get(bedrockIdentifier);
                            customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(javaItem.javaIdentifier(), null);
                            if (customBlockData != null && customBlockData.includedInCreativeInventory()) {
                                CustomBlockState customBlockState = customBlockData.defaultBlockState();
                                customBlockItemOverride = blockMappings.getCustomBlockStateDefinitions().getOrDefault(customBlockState, null);
                            }
                            if (blockOverride == null || customBlockItemOverride != null) break block72;
                            bedrockBlock = blockOverride;
                            break block71;
                        }
                        aValidBedrockBlockId = blacklistedIdentifiers.getOrDefault((Object)bedrockIdentifier, customBlockItemOverride != null ? customBlockItemOverride.getRuntimeId() : -1);
                        if (aValidBedrockBlockId != -1 || customBlockItemOverride != null) break block73;
                        if (noBlockDefinitions.contains(entry.getValue().getBedrockIdentifier())) break block71;
                        bedrockBlock = blockMappings.getBedrockBlock(firstBlockRuntimeId);
                        break block71;
                    }
                    NbtMapBuilder requiredBlockStatesBuilder = NbtMap.builder();
                    String correctBedrockIdentifier = blockMappings.getDefinition(aValidBedrockBlockId).getState().getString("name");
                    boolean firstPass = true;
                    int lastBlockRuntimeId = entry.getValue().getLastBlockRuntimeId() == null ? firstBlockRuntimeId : entry.getValue().getLastBlockRuntimeId();
                    for (int i = firstBlockRuntimeId.intValue(); i <= lastBlockRuntimeId; ++i) {
                        GeyserBedrockBlock[] bedrockBlockRuntimeId = blockMappings.getVanillaBedrockBlock(i);
                        NbtMap blockTag2 = bedrockBlockRuntimeId.getState();
                        String bedrockName = blockTag2.getString("name");
                        if (!bedrockName.equals(correctBedrockIdentifier)) continue;
                        NbtMap states = blockTag2.getCompound("states");
                        if (firstPass) {
                            firstPass = false;
                            if (states.isEmpty()) {
                                bedrockBlock = bedrockBlockRuntimeId;
                                break;
                            }
                            requiredBlockStatesBuilder.putAll(states);
                            continue;
                        }
                        for (Map.Entry<String, Object> entry2 : states.entrySet()) {
                            Object value = requiredBlockStatesBuilder.get(entry2.getKey());
                            if (value == null || entry2.getValue().equals(value)) continue;
                            requiredBlockStatesBuilder.remove(entry2.getKey());
                        }
                        if (requiredBlockStatesBuilder.isEmpty()) break;
                    }
                    NbtMap requiredBlockStates = requiredBlockStatesBuilder.build();
                    if (bedrockBlock == null) {
                        for (GeyserBedrockBlock block : blockMappings.getBedrockRuntimeMap()) {
                            if (block == null || !((NbtMap)(blockTag = block.getState())).getString("name").equals(correctBedrockIdentifier)) continue;
                            NbtMap nbtMap = ((NbtMap)blockTag).getCompound("states");
                            boolean valid = true;
                            for (Map.Entry<String, Object> nbtEntry : requiredBlockStates.entrySet()) {
                                if (nbtMap.get(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            bedrockBlock = block;
                            break;
                        }
                        if (bedrockBlock == null) {
                            throw new RuntimeException("Could not find a block match for " + entry.getKey());
                        }
                    }
                    if (customBlockItemOverride != null) {
                        bedrockBlock = customBlockItemOverride;
                    }
                    for (int j = 0; j < creativeItems.size(); ++j) {
                        CreativeItemData itemData = (CreativeItemData)creativeItems.get(j);
                        if (!itemData.getItem().getDefinition().equals(definition)) continue;
                        if (itemData.getItem().getDamage() != 0) break;
                        NbtMap states = ((GeyserBedrockBlock)itemData.getItem().getBlockDefinition()).getState().getCompound("states");
                        boolean valid = true;
                        blockTag = requiredBlockStates.entrySet().iterator();
                        while (blockTag.hasNext()) {
                            Map.Entry entry3 = (Map.Entry)blockTag.next();
                            if (Objects.equals(states.get(entry3.getKey()), entry3.getValue())) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        if (customBlockItemOverride != null && customBlockData != null) {
                            int customProtocolId = nextFreeBedrockId++;
                            mappingItem = mappingItem.withBedrockData(customProtocolId);
                            bedrockIdentifier = customBlockData.identifier();
                            definition = new SimpleItemDefinition(bedrockIdentifier, customProtocolId, ItemVersion.DATA_DRIVEN, true, NbtMap.EMPTY);
                            registry.put(customProtocolId, definition);
                            customBlockItemDefinitions.put(customBlockData, definition);
                            customIdMappings.put(customProtocolId, bedrockIdentifier);
                            CreativeItemCategory creativeItemCategory = customBlockData.creativeCategory() == null ? CreativeItemCategory.UNDEFINED : CreativeItemCategory.values()[customBlockData.creativeCategory().ordinal()];
                            CreativeItemData newData = new CreativeItemData(itemData.getItem().toBuilder().definition(definition).blockDefinition((BlockDefinition)bedrockBlock).netId(itemData.getNetId()).count(1).build(), itemData.getNetId(), ItemRegistryPopulator.getCreativeIndex(customBlockData.creativeGroup(), creativeItemCategory, creativeGroupIds, lastCreativeGroupIds, creativeItemGroups));
                            creativeItems.set(j, newData);
                            break;
                        }
                        CreativeItemData creativeItemData2 = new CreativeItemData(itemData.getItem().toBuilder().blockDefinition((BlockDefinition)bedrockBlock).build(), itemData.getNetId(), itemData.getGroupId());
                        creativeItems.set(j, creativeItemData2);
                        break;
                    }
                }
                ItemMapping.ItemMappingBuilder mappingBuilder = ItemMapping.builder().bedrockIdentifier(bedrockIdentifier.intern()).bedrockDefinition(definition).bedrockData(mappingItem.getBedrockData()).bedrockBlockDefinition((BlockDefinition)bedrockBlock).javaItem(javaItem);
                if (mappingItem.getToolType() != null) {
                    mappingBuilder = mappingBuilder.toolType(mappingItem.getToolType().intern());
                }
                if (javaOnlyItems.contains(javaItem)) {
                    mappingBuilder = mappingBuilder.translationString((javaItem instanceof BlockItem ? "block." : "item.") + entry.getKey().replace(":", "."));
                    GeyserImpl.getInstance().getLogger().debug("Adding " + entry.getKey() + " as an item that needs to be translated.");
                }
                Collection customItemsToLoad = customItems.get((Object)Identifier.of(javaItem.javaIdentifier()));
                if (customItemsAllowed && !customItemsToLoad.isEmpty()) {
                    customItemDefinitions = MultimapBuilder.hashKeys((int)customItemsToLoad.size()).treeSetValues((Comparator)new CustomItemDefinitionComparator()).build();
                    for (CustomItemDefinition customItem : customItemsToLoad) {
                        int customProtocolId = nextFreeBedrockId++;
                        Identifier customItemIdentifier = customItem.bedrockIdentifier();
                        if (!registeredCustomItems.add(customItemIdentifier)) {
                            if (!firstMappingsPass) continue;
                            GeyserImpl.getInstance().getLogger().error("Custom item '" + String.valueOf(customItemIdentifier) + "' already exists and was registered again! Skipping...");
                            continue;
                        }
                        try {
                            GeyserCustomMappingData customMapping = CustomItemRegistryPopulator.registerCustomItem(javaItem, mappingItem, customItem, customProtocolId, palette.protocolVersion);
                            if (customItem.bedrockOptions().creativeCategory() != CreativeCategory.NONE) {
                                CreativeItemData creativeItemData3 = new CreativeItemData(ItemData.builder().netId(creativeNetId.incrementAndGet()).definition(customMapping.itemDefinition()).blockDefinition(null).count(1).build(), creativeNetId.get(), ItemRegistryPopulator.getCreativeIndex(customItem.bedrockOptions().creativeGroup(), CreativeItemCategory.values()[customItem.bedrockOptions().creativeCategory().id()], creativeGroupIds, lastCreativeGroupIds, creativeItemGroups));
                                creativeItems.add(creativeItemData3);
                            }
                            customItemDefinitions.put((Object)MinecraftKey.identifierToKey(customItem.model()), (Object)customMapping);
                            registry.put(customMapping.integerId(), customMapping.itemDefinition());
                            customIdMappings.put(customMapping.integerId(), customItemIdentifier.toString());
                        }
                        catch (InvalidItemComponentsException exception) {
                            if (!firstMappingsPass) continue;
                            GeyserImpl.getInstance().getLogger().error("Not registering custom item (bedrock identifier=" + String.valueOf(customItem.bedrockIdentifier()) + ")!", exception);
                        }
                    }
                } else {
                    customItemDefinitions = null;
                }
                mappingBuilder.customItemDefinitions(customItemDefinitions);
                ItemMapping mapping = mappingBuilder.build();
                if (javaItem.javaIdentifier().contains("bucket") && !javaItem.javaIdentifier().contains("milk")) {
                    buckets.add(definition);
                }
                mappings.add(mapping);
                javaItemToMapping.put(javaItem, mapping);
            }
            Int2ObjectOpenHashMap<ItemMapping> lightBlocks = new Int2ObjectOpenHashMap<ItemMapping>();
            for (int i = 0; i <= Properties.LEVEL.high() && (lightBlock = (ItemDefinition)definitions.get("minecraft:light_block_" + i)) != null; ++i) {
                ItemMapping lightBlockEntry = ItemMapping.builder().javaItem(Items.LIGHT).bedrockIdentifier("minecraft:light_block_" + i).bedrockDefinition(lightBlock).bedrockData(0).bedrockBlockDefinition(null).customItemDefinitions(null).build();
                lightBlocks.put(lightBlock.getRuntimeId(), lightBlockEntry);
            }
            ItemDefinition lodestoneCompass = (ItemDefinition)definitions.get("minecraft:lodestone_compass");
            if (lodestoneCompass == null) {
                throw new RuntimeException("Lodestone compass not found in item palette!");
            }
            ItemMapping lodestoneEntry = ItemMapping.builder().javaItem(Items.COMPASS).bedrockIdentifier("minecraft:lodestone_compass").bedrockDefinition(lodestoneCompass).bedrockData(0).bedrockBlockDefinition(null).customItemDefinitions(null).build();
            IntOpenHashSet nonVanillaCustomItemIds = new IntOpenHashSet();
            if (customItemsAllowed) {
                int furnaceMinecartId = nextFreeBedrockId++;
                SimpleItemDefinition definition = new SimpleItemDefinition("geysermc:furnace_minecart", furnaceMinecartId, ItemVersion.DATA_DRIVEN, true, ItemRegistryPopulator.registerFurnaceMinecart(furnaceMinecartId));
                definitions.put("geysermc:furnace_minecart", definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
                mappings.set(Items.FURNACE_MINECART.javaId(), ItemMapping.builder().javaItem(Items.FURNACE_MINECART).bedrockIdentifier("geysermc:furnace_minecart").bedrockDefinition(definition).bedrockData(0).bedrockBlockDefinition(null).customItemDefinitions(null).build());
                creativeItems.add(new CreativeItemData(ItemData.builder().usingNetId(true).netId(creativeNetId.incrementAndGet()).definition(definition).count(1).build(), creativeNetId.get(), ItemRegistryPopulator.getCreativeIndex("itemGroup.name.minecart", CreativeItemCategory.ITEMS, creativeGroupIds, lastCreativeGroupIds, creativeItemGroups)));
                IntOpenHashSet registeredJavaIds = new IntOpenHashSet();
                for (NonVanillaCustomItemDefinition customItem : nonVanillaCustomItems.values()) {
                    if (!registeredJavaIds.add(customItem.javaId())) {
                        throw new IllegalStateException("Custom item java id " + customItem.javaId() + " already exists and was registered again!");
                    }
                    int customItemId = nextFreeBedrockId++;
                    try {
                        NonVanillaItemRegistration registration = CustomItemRegistryPopulator.registerCustomItem(customItem, customItemId, palette.protocolVersion);
                        ItemMapping mapping = registration.mapping();
                        Item javaItem = registration.javaItem();
                        while (javaItem.javaId() >= mappings.size()) {
                            mappings.add(ItemMapping.AIR);
                        }
                        mappings.set(javaItem.javaId(), mapping);
                        registry.put(customItemId, mapping.getBedrockDefinition());
                        nonVanillaCustomItemIds.add(javaItem.javaId());
                        if (customItem.bedrockOptions().creativeCategory() == CreativeCategory.NONE) continue;
                        creativeItemData = new CreativeItemData(ItemData.builder().definition(registration.mapping().getBedrockDefinition()).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), ItemRegistryPopulator.getCreativeIndex(customItem.bedrockOptions().creativeGroup(), CreativeItemCategory.values()[customItem.bedrockOptions().creativeCategory().id()], creativeGroupIds, lastCreativeGroupIds, creativeItemGroups));
                        creativeItems.add(creativeItemData);
                    }
                    catch (InvalidItemComponentsException exception) {
                        GeyserImpl.getInstance().getLogger().error("Not registering non-vanilla custom item (identifier=" + String.valueOf(customItem.identifier()) + ")!", exception);
                    }
                }
            }
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    if (customBlockItemDefinitions.containsKey(customBlock) || customBlock instanceof NonVanillaCustomBlockData) continue;
                    int customProtocolId = nextFreeBedrockId++;
                    String identifier = customBlock.identifier();
                    SimpleItemDefinition definition = new SimpleItemDefinition(identifier, customProtocolId, ItemVersion.NONE, false, null);
                    registry.put(customProtocolId, (ItemDefinition)definition);
                    customBlockItemDefinitions.put(customBlock, definition);
                    customIdMappings.put(customProtocolId, identifier);
                    GeyserBedrockBlock bedrockBlock = blockMappings.getCustomBlockStateDefinitions().getOrDefault(customBlock.defaultBlockState(), null);
                    if (bedrockBlock == null || !customBlock.includedInCreativeInventory()) continue;
                    CreativeItemCategory category = customBlock.creativeCategory() == null ? CreativeItemCategory.UNDEFINED : CreativeItemCategory.values()[customBlock.creativeCategory().ordinal()];
                    creativeItemData = new CreativeItemData(ItemData.builder().definition(definition).blockDefinition(bedrockBlock).netId(creativeNetId.incrementAndGet()).count(1).build(), creativeNetId.get(), ItemRegistryPopulator.getCreativeIndex(customBlock.creativeGroup(), category, creativeGroupIds, lastCreativeGroupIds, creativeItemGroups));
                    creativeItems.add(creativeItemData);
                }
            }
            ItemMappings itemMappings = ItemMappings.builder().items(mappings.toArray(new ItemMapping[0])).creativeItems(creativeItems).creativeItemGroups(creativeItemGroups).itemDefinitions(registry).storedItems(new StoredItemMappings(javaItemToMapping)).javaOnlyItems(javaOnlyItems).buckets(buckets).lightBlocks(lightBlocks).lodestoneCompass(lodestoneEntry).customIdMappings(customIdMappings).nonVanillaCustomItemIds(nonVanillaCustomItemIds).customBlockItemDefinitions(customBlockItemDefinitions).build();
            Registries.ITEMS.register(palette.protocolVersion(), itemMappings);
            firstMappingsPass = false;
        }
    }

    private static NbtMap registerFurnaceMinecart(int nextFreeBedrockId) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", "geysermc:furnace_minecart").putInt("id", nextFreeBedrockId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        NbtMap iconMap = NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", "minecart_furnace").build()).build();
        itemProperties.putCompound("minecraft:icon", iconMap);
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", "item.minecartFurnace.name").build());
        List<NbtMap> useOnTag = Collections.singletonList(NbtMap.builder().putString("tags", "q.any_tag('rail')").build());
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.COMPOUND, useOnTag).putString("entity", "minecraft:minecart").putList("use_on", NbtType.COMPOUND, useOnTag).build());
        itemProperties.putBoolean("allow_off_hand", true);
        itemProperties.putBoolean("hand_equipped", false);
        itemProperties.putInt("max_stack_size", 1);
        itemProperties.putString("creative_group", "itemGroup.name.minecart");
        itemProperties.putInt("creative_category", 4);
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder.build();
    }

    public static int getCreativeIndex(String creativeGroup, CreativeItemCategory creativeItemCategory, Map<String, Integer> groupIndexes, Map<CreativeItemCategory, Integer> fallBacks, List<CreativeItemGroup> creativeItemGroups) {
        if (fallBacks.isEmpty()) {
            return 0;
        }
        if (creativeGroup != null && groupIndexes.containsKey(creativeGroup)) {
            return groupIndexes.get(creativeGroup);
        }
        if (creativeItemCategory != null) {
            if (fallBacks.containsKey((Object)creativeItemCategory)) {
                return fallBacks.get((Object)creativeItemCategory);
            }
            creativeItemGroups.add(new CreativeItemGroup(creativeItemCategory, "", ItemData.AIR));
            fallBacks.put(creativeItemCategory, creativeItemGroups.size() - 1);
            return fallBacks.get((Object)creativeItemCategory);
        }
        return fallBacks.get((Object)CreativeItemCategory.UNDEFINED);
    }

    record PaletteVersion(String version, int protocolVersion, Map<Item, Item> javaOnlyItems, Remapper remapper) {
        public PaletteVersion(String version, int protocolVersion) {
            this(version, protocolVersion, Collections.emptyMap(), (item, mapping) -> mapping);
        }

        public PaletteVersion(String version, int protocolVersion, Map<Item, Item> javaOnlyItems) {
            this(version, protocolVersion, javaOnlyItems, (item, mapping) -> mapping);
        }

        public PaletteVersion(String version, int protocolVersion, Remapper remapper) {
            this(version, protocolVersion, Collections.emptyMap(), remapper);
        }
    }

    @FunctionalInterface
    static interface Remapper {
        public @NonNull GeyserMappingItem remap(Item var1, GeyserMappingItem var2);
    }

    private static class CustomItemDefinitionComparator
    implements Comparator<GeyserCustomMappingData> {
        private CustomItemDefinitionComparator() {
        }

        @Override
        public int compare(GeyserCustomMappingData firstData, GeyserCustomMappingData secondData) {
            CustomItemDefinition second;
            CustomItemDefinition first = firstData.definition();
            if (first.equals(second = secondData.definition())) {
                return 0;
            }
            if (!first.model().equals(second.model())) {
                return first.bedrockIdentifier().toString().compareTo(second.bedrockIdentifier().toString());
            }
            if (first.priority() != second.priority()) {
                return second.priority() - first.priority();
            }
            if (first.predicates().isEmpty() ^ second.predicates().isEmpty()) {
                return second.predicates().size() - first.predicates().size();
            }
            for (MinecraftPredicate<? super ItemPredicateContext> predicate : first.predicates()) {
                if (!(predicate instanceof GeyserRangeDispatchPredicate)) continue;
                GeyserRangeDispatchPredicate rangeDispatch = (GeyserRangeDispatchPredicate)predicate;
                Optional<GeyserRangeDispatchPredicate> other = second.predicates().stream().filter(GeyserRangeDispatchPredicate.class::isInstance).map(GeyserRangeDispatchPredicate.class::cast).filter(otherPredicate -> otherPredicate.rangeProperty() == rangeDispatch.rangeProperty() && otherPredicate.index() == rangeDispatch.index() && otherPredicate.normalised() == rangeDispatch.normalised() && otherPredicate.negated() == rangeDispatch.negated()).findFirst();
                if (!other.isPresent()) continue;
                return (int)(rangeDispatch.negated() ? rangeDispatch.threshold() - other.get().threshold() : other.get().threshold() - rangeDispatch.threshold());
            }
            if (first.predicates().size() == second.predicates().size()) {
                return first.bedrockIdentifier().toString().compareTo(second.bedrockIdentifier().toString());
            }
            return second.predicates().size() - first.predicates().size();
        }
    }
}

