/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.Chargeable;
import org.geysermc.geyser.api.util.Identifier;

public record ChargeableImpl(@NonNegative float maxDrawDuration, boolean chargeOnDraw, @NonNull List<@NonNull Identifier> ammunition) implements Chargeable
{

    public static class Builder
    implements Chargeable.Builder {
        private float maxDrawDuration;
        private boolean chargeOnDraw;
        private final List<Identifier> ammunition = new ArrayList<Identifier>();

        @Override
        public Chargeable.Builder maxDrawDuration(@NonNegative float maxDrawDuration) {
            if (maxDrawDuration < 0.0f) {
                throw new IllegalArgumentException("maxDrawDuration must be positive");
            }
            this.maxDrawDuration = maxDrawDuration;
            return this;
        }

        @Override
        public Chargeable.Builder chargeOnDraw(boolean chargeOnDraw) {
            this.chargeOnDraw = chargeOnDraw;
            return this;
        }

        @Override
        public Chargeable.Builder ammunition(@NonNull Identifier ammunition) {
            Objects.requireNonNull(ammunition, "ammunition cannot be null");
            if (this.ammunition.contains(ammunition)) {
                throw new IllegalArgumentException("duplicate ammunition " + String.valueOf(ammunition));
            }
            this.ammunition.add(ammunition);
            return this;
        }

        @Override
        public Chargeable build() {
            Objects.requireNonNull(this.ammunition, "ammunition cannot be null");
            return new ChargeableImpl(this.maxDrawDuration, this.chargeOnDraw, List.copyOf(this.ammunition));
        }
    }
}

