/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import net.kyori.adventure.key.Key;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerStartItemCooldownPacket;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundCooldownPacket;

@Translator(packet=ClientboundCooldownPacket.class)
public class JavaCooldownTranslator
extends PacketTranslator<ClientboundCooldownPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundCooldownPacket packet) {
        Key cooldownGroup = packet.getCooldownGroup();
        Item item = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(cooldownGroup.asString());
        String cooldownCategory = cooldownGroup.asString();
        if (item == Items.GOAT_HORN) {
            cooldownCategory = "goat_horn";
        } else if (item == Items.SHIELD) {
            cooldownCategory = "shield";
        }
        PlayerStartItemCooldownPacket bedrockPacket = new PlayerStartItemCooldownPacket();
        bedrockPacket.setItemCategory(cooldownCategory);
        bedrockPacket.setCooldownDuration(Math.round((float)packet.getCooldownTicks() * (session.getMillisecondsPerTick() / 50.0f)));
        session.sendUpstreamPacket((BedrockPacket)bedrockPacket);
        session.getWorldCache().setCooldown(cooldownGroup, packet.getCooldownTicks());
    }
}

