/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.TakeItemEntityPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ExpOrbEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundTakeItemEntityPacket;

@Translator(packet=ClientboundTakeItemEntityPacket.class)
public class JavaTakeItemEntityTranslator
extends PacketTranslator<ClientboundTakeItemEntityPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundTakeItemEntityPacket packet) {
        Entity collectedEntity = session.getEntityCache().getEntityByJavaId(packet.getCollectedEntityId());
        if (collectedEntity == null) {
            return;
        }
        Entity collectorEntity = session.getEntityCache().getEntityByJavaId(packet.getCollectorEntityId());
        if (collectorEntity == null) {
            return;
        }
        if (collectedEntity instanceof ExpOrbEntity) {
            LevelEventPacket xpPacket = new LevelEventPacket();
            xpPacket.setType((LevelEventType)LevelEvent.SOUND_EXPERIENCE_ORB_PICKUP);
            xpPacket.setPosition(collectedEntity.getPosition());
            xpPacket.setData(0);
            session.sendUpstreamPacket((BedrockPacket)xpPacket);
        } else {
            TakeItemEntityPacket takeItemEntityPacket = new TakeItemEntityPacket();
            takeItemEntityPacket.setRuntimeEntityId(collectorEntity.getGeyserId());
            takeItemEntityPacket.setItemRuntimeEntityId(collectedEntity.getGeyserId());
            session.sendUpstreamPacket((BedrockPacket)takeItemEntityPacket);
        }
    }
}

