/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTrimRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.TrimDataPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.inventory.recipe.TrimRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.GeyserHolderSet;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundUpdateRecipesPacket;

@Translator(packet=ClientboundUpdateRecipesPacket.class)
public class JavaUpdateRecipesTranslator
extends PacketTranslator<ClientboundUpdateRecipesPacket> {
    private static final List<String> NETHERITE_UPGRADES = List.of("minecraft:netherite_sword", "minecraft:netherite_shovel", "minecraft:netherite_pickaxe", "minecraft:netherite_axe", "minecraft:netherite_hoe", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots");
    private static final Key SMITHING_BASE = MinecraftKey.key("smithing_base");
    private static final Key SMITHING_TEMPLATE = MinecraftKey.key("smithing_template");
    private static final Key SMITHING_ADDITION = MinecraftKey.key("smithing_addition");

    @Override
    public void translate(GeyserSession session, ClientboundUpdateRecipesPacket packet) {
        boolean oldSmithingTable;
        int netId = session.getLastRecipeNetId().get();
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        int[] smithingBase = (int[])packet.getItemSets().get(SMITHING_BASE);
        int[] smithingTemplate = (int[])packet.getItemSets().get(SMITHING_TEMPLATE);
        int[] smithingAddition = (int[])packet.getItemSets().get(SMITHING_ADDITION);
        if (smithingBase == null || smithingTemplate == null || smithingAddition == null) {
            oldSmithingTable = true;
            this.addSmithingTransformRecipes(session, craftingDataPacket.getCraftingData());
            netId = session.getLastRecipeNetId().get();
        } else {
            oldSmithingTable = false;
            TrimDataPacket trimDataPacket = new TrimDataPacket();
            trimDataPacket.getPatterns().addAll(session.getRegistryCache().registry(JavaRegistries.TRIM_PATTERN).values());
            trimDataPacket.getMaterials().addAll(session.getRegistryCache().registry(JavaRegistries.TRIM_MATERIAL).values());
            session.sendUpstreamPacket((BedrockPacket)trimDataPacket);
            craftingDataPacket.getCraftingData().add(SmithingTrimRecipeData.of((String)"minecraft:smithing_armor_trim", (ItemDescriptorWithCount)TrimRecipe.BASE, (ItemDescriptorWithCount)TrimRecipe.ADDITION, (ItemDescriptorWithCount)TrimRecipe.TEMPLATE, (String)"smithing_table", (int)netId++));
        }
        session.getGeyser().getLogger().debug("Using old smithing table workaround? " + oldSmithingTable);
        session.setOldSmithingTable(oldSmithingTable);
        Int2ObjectOpenHashMap rawStonecutterData = new Int2ObjectOpenHashMap();
        List stonecutterRecipes = packet.getStonecutterRecipes();
        for (ClientboundUpdateRecipesPacket.SelectableRecipe recipe : stonecutterRecipes) {
            int[] ingredients;
            if (!(recipe.recipe() instanceof ItemStackSlotDisplay)) {
                session.getGeyser().getLogger().warning("Ignoring stonecutter recipe for weird output: " + String.valueOf(recipe));
                continue;
            }
            for (int ingredient : ingredients = GeyserHolderSet.fromHolderSet(JavaRegistries.ITEM, recipe.input().getValues()).resolveRaw(session.getTagCache())) {
                ((List)rawStonecutterData.computeIfAbsent(ingredient, $ -> new ArrayList())).add(recipe);
            }
        }
        Int2ObjectOpenHashMap stonecutterRecipeMap = new Int2ObjectOpenHashMap();
        for (Int2ObjectMap.Entry data : rawStonecutterData.int2ObjectEntrySet()) {
            int buttonId = 0;
            for (ClientboundUpdateRecipesPacket.SelectableRecipe recipe : (List)data.getValue()) {
                HolderSet ingredient = recipe.input().getValues();
                int javaInput = data.getIntKey();
                ItemMapping mapping = session.getItemMappings().getMapping(javaInput);
                if (mapping.getJavaItem() == Items.AIR) continue;
                ItemDescriptorWithCount descriptor = new ItemDescriptorWithCount((ItemDescriptor)new DefaultDescriptor(mapping.getBedrockDefinition(), mapping.getBedrockData()), 1);
                ItemStack javaOutput = ((ItemStackSlotDisplay)recipe.recipe()).itemStack();
                ItemData output = ItemTranslator.translateToBedrock(session, javaOutput);
                if (!output.isValid()) continue;
                int recipeNetId = netId++;
                UUID uuid = UUID.randomUUID();
                craftingDataPacket.getCraftingData().add(ShapelessRecipeData.shapeless((String)("stonecutter_" + javaInput + "_" + buttonId), Collections.singletonList(descriptor), Collections.singletonList(output), (UUID)uuid, (String)"stonecutter", (int)0, (int)recipeNetId, (RecipeUnlockingRequirement)RecipeUnlockingRequirement.INVALID));
                stonecutterRecipeMap.put(recipeNetId, (Object)new GeyserStonecutterData(buttonId++, javaOutput));
            }
        }
        session.sendUpstreamPacket((BedrockPacket)craftingDataPacket);
        session.setStonecutterRecipes((Int2ObjectMap<GeyserStonecutterData>)stonecutterRecipeMap);
        session.getLastRecipeNetId().set(netId);
    }

    private void addSmithingTransformRecipes(GeyserSession session, List<RecipeData> recipes) {
        ItemMapping template = session.getItemMappings().getStoredItems().upgradeTemplate();
        for (String identifier : NETHERITE_UPGRADES) {
            recipes.add((RecipeData)SmithingTransformRecipeData.of((String)(identifier + "_smithing"), (ItemDescriptorWithCount)this.getDescriptorFromId(session, template.getBedrockIdentifier()), (ItemDescriptorWithCount)this.getDescriptorFromId(session, identifier.replace("netherite", "diamond")), (ItemDescriptorWithCount)this.getDescriptorFromId(session, "minecraft:netherite_ingot"), (ItemData)ItemData.builder().definition(Objects.requireNonNull(session.getItemMappings().getDefinition(identifier))).count(1).build(), (String)"smithing_table", (int)session.getLastRecipeNetId().getAndIncrement()));
        }
    }

    private ItemDescriptorWithCount getDescriptorFromId(GeyserSession session, String bedrockId) {
        ItemDefinition bedrockDefinition = session.getItemMappings().getDefinition(bedrockId);
        if (bedrockDefinition != null) {
            return ItemDescriptorWithCount.fromItem((ItemData)ItemData.builder().definition(bedrockDefinition).count(1).build());
        }
        GeyserImpl.getInstance().getLogger().debug("Unable to find item with identifier " + bedrockId);
        return ItemDescriptorWithCount.EMPTY;
    }
}

