/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;

@Translator(packet=ClientboundKeepAlivePacket.class)
public class JavaKeepAliveTranslator
extends PacketTranslator<ClientboundKeepAlivePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundKeepAlivePacket packet) {
        if (!session.getGeyser().config().gameplay().forwardPlayerPing()) {
            return;
        }
        session.getKeepAliveCache().add(packet.getPingId());
        long timestamp = packet.getPingId();
        timestamp = timestamp == Long.MIN_VALUE ? Long.MAX_VALUE : Math.absExact(timestamp);
        while ((double)timestamp > 1.0E10) {
            timestamp /= 10L;
        }
        NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
        latencyPacket.setFromServer(true);
        latencyPacket.setTimestamp(timestamp);
        session.sendUpstreamPacketImmediately((BedrockPacket)latencyPacket);
    }
}

