/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.util.JsonUtils;

public class BiomeIdentifierRegistryLoader
implements RegistryLoader<String, Object2IntMap<String>> {
    @Override
    public Object2IntMap<String> load(String input) {
        Map biomeEntries;
        Type biomeEntriesType = new TypeToken<Map<String, BiomeEntry>>(){}.getType();
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/biomes.json");){
            biomeEntries = (Map)JsonUtils.fromJson(stream, biomeEntriesType);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Bedrock runtime biomes", e);
        }
        Object2IntOpenHashMap biomes = new Object2IntOpenHashMap();
        for (Map.Entry biome : biomeEntries.entrySet()) {
            biomes.put((Object)((String)biome.getKey()), ((BiomeEntry)biome.getValue()).bedrockId);
        }
        return biomes;
    }

    private static class BiomeEntry {
        @SerializedName(value="bedrock_id")
        private int bedrockId;

        private BiomeEntry() {
        }
    }
}

