/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponentMap;
import org.geysermc.geyser.api.item.custom.v2.component.java.Consumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.Equippable;
import org.geysermc.geyser.api.item.custom.v2.component.java.ItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.Repairable;
import org.geysermc.geyser.api.item.custom.v2.component.java.ToolProperties;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.components.resolvable.ResolvableComponent;
import org.geysermc.geyser.item.components.resolvable.ResolvableRepairable;
import org.geysermc.geyser.item.components.resolvable.ResolvableToolProperties;
import org.geysermc.geyser.item.exception.InvalidItemComponentsException;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.FoodProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public class ComponentConverters {
    private static final Map<DataComponent<?>, ResolvableComponentConverter<?>> converters = new HashMap();

    private static <T> void registerConverter(DataComponent<T> component, DataComponentType<T> converted) {
        ComponentConverters.registerConverter(component, (DataComponents itemMap, T value) -> itemMap.put(converted, value));
    }

    private static <T> void registerConverter(DataComponent<T> component, ComponentConverter<T> converter) {
        ComponentConverters.registerConverter(component, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> resolvableConsumer) -> converter.convertAndPut(itemMap, value));
    }

    private static <T> void registerConverter(DataComponent<T> component, ResolvableComponentConverter<T> converter) {
        converters.put(component, converter);
    }

    public static DataComponents convertComponentPatch(DataComponentMap customDefinitionPatch, List<Identifier> customDefinitionRemovals, Consumer<ResolvableComponent<?>> resolvableConsumer) throws InvalidItemComponentsException {
        DataComponents converted = new DataComponents(new HashMap());
        for (DataComponent<?> component : customDefinitionPatch.keySet()) {
            if (customDefinitionRemovals.contains(component.identifier())) {
                throw new InvalidItemComponentsException("Component " + String.valueOf(component.identifier()) + " was present both in the components to add and the components to remove");
            }
            ResolvableComponentConverter<?> converter = converters.get(component);
            if (converter == null) continue;
            Object value = customDefinitionPatch.get(component);
            converter.convert(converted, value, resolvableConsumer);
        }
        for (Identifier removed : customDefinitionRemovals) {
            DataComponentType component = DataComponentTypes.fromKey((Key)MinecraftKey.identifierToKey(removed));
            if (component == null) continue;
            converted.put(component, null);
        }
        return converted;
    }

    static {
        ComponentConverters.registerConverter(ItemDataComponents.CONSUMABLE, (DataComponents itemMap, T value) -> {
            Consumable.ItemUseAnimation convertedAnimation = switch (value.animation()) {
                default -> throw new IncompatibleClassChangeError();
                case Consumable.Animation.NONE -> Consumable.ItemUseAnimation.NONE;
                case Consumable.Animation.EAT -> Consumable.ItemUseAnimation.EAT;
                case Consumable.Animation.DRINK -> Consumable.ItemUseAnimation.DRINK;
                case Consumable.Animation.BLOCK -> Consumable.ItemUseAnimation.BLOCK;
                case Consumable.Animation.BOW -> Consumable.ItemUseAnimation.BOW;
                case Consumable.Animation.SPEAR -> Consumable.ItemUseAnimation.SPEAR;
                case Consumable.Animation.CROSSBOW -> Consumable.ItemUseAnimation.CROSSBOW;
                case Consumable.Animation.SPYGLASS -> Consumable.ItemUseAnimation.SPYGLASS;
                case Consumable.Animation.BRUSH -> Consumable.ItemUseAnimation.BRUSH;
            };
            itemMap.put(DataComponentTypes.CONSUMABLE, (Object)new Consumable(value.consumeSeconds(), convertedAnimation, (Sound)BuiltinSound.ENTITY_GENERIC_EAT, true, List.of()));
        });
        ComponentConverters.registerConverter(ItemDataComponents.EQUIPPABLE, (DataComponents itemMap, T value) -> {
            EquipmentSlot convertedSlot = switch (value.slot()) {
                default -> throw new IncompatibleClassChangeError();
                case Equippable.EquipmentSlot.HEAD -> EquipmentSlot.HELMET;
                case Equippable.EquipmentSlot.CHEST -> EquipmentSlot.CHESTPLATE;
                case Equippable.EquipmentSlot.LEGS -> EquipmentSlot.LEGGINGS;
                case Equippable.EquipmentSlot.FEET -> EquipmentSlot.BOOTS;
                case Equippable.EquipmentSlot.BODY -> EquipmentSlot.BODY;
                case Equippable.EquipmentSlot.SADDLE -> EquipmentSlot.SADDLE;
            };
            itemMap.put(DataComponentTypes.EQUIPPABLE, (Object)new Equippable(convertedSlot, (Sound)BuiltinSound.ITEM_ARMOR_EQUIP_GENERIC, null, null, null, false, false, false, false, false, null));
        });
        ComponentConverters.registerConverter(ItemDataComponents.FOOD, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.FOOD, (Object)new FoodProperties(value.nutrition(), value.saturation(), value.canAlwaysEat())));
        ComponentConverters.registerConverter(ItemDataComponents.MAX_DAMAGE, DataComponentTypes.MAX_DAMAGE);
        ComponentConverters.registerConverter(ItemDataComponents.MAX_STACK_SIZE, DataComponentTypes.MAX_STACK_SIZE);
        ComponentConverters.registerConverter(ItemDataComponents.USE_COOLDOWN, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.USE_COOLDOWN, (Object)new UseCooldown(value.seconds(), MinecraftKey.identifierToKey(value.cooldownGroup()))));
        ComponentConverters.registerConverter(ItemDataComponents.ENCHANTABLE, DataComponentTypes.ENCHANTABLE);
        ComponentConverters.registerConverter(ItemDataComponents.TOOL, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> consumer) -> {
            itemMap.put(DataComponentTypes.TOOL, (Object)new ToolData(List.of(), 1.0f, 1, value.canDestroyBlocksInCreative()));
            consumer.accept(new ResolvableToolProperties((ToolProperties)value));
        });
        ComponentConverters.registerConverter(ItemDataComponents.REPAIRABLE, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> consumer) -> consumer.accept(new ResolvableRepairable((Repairable)value)));
        ComponentConverters.registerConverter(ItemDataComponents.ENCHANTMENT_GLINT_OVERRIDE, DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
    }

    @FunctionalInterface
    public static interface ComponentConverter<T> {
        public void convertAndPut(DataComponents var1, T var2);
    }

    @FunctionalInterface
    public static interface ResolvableComponentConverter<T> {
        public void convert(DataComponents var1, T var2, Consumer<ResolvableComponent<?>> var3);
    }
}

