/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.inventory.EnchantData;
import org.cloudburstmc.protocol.bedrock.data.inventory.EnchantOptionData;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserEnchantOption {
    private static final List<EnchantData> EMPTY = Collections.emptyList();
    private static final List<String> ENCHANT_NAMES = List.of("tougher armor", "lukeeey", "fall better", "explode less", "camo toy", "armor stab", "breathe better", "water walk", "rtm five one six", "oof ouch owie", "enemy on fire", "spider sad", "aj ferguson", "redned", "more items thx", "fast tool", "give me block", "less breaky break", "cube craft", "strong arrow", "fist arrow", "spicy arrow", "many many arrows", "geyser", "come here fish", "you are elsa", "xp heals tools", "tim two zero three", "dragon proxy waz here", "stabby stab", "supreme mortal", "i like this", "avatar i guess", "more arrows", "in and out", "fly finder seventeen", "fast walk nether", "davchoo", "onechris", "death bringer thirteen", "kastle");
    private final int javaIndex;
    private boolean hasChanged;
    private int xpCost = 0;
    private int bedrockEnchantIndex = -1;
    private int enchantLevel = -1;

    public GeyserEnchantOption(int javaIndex) {
        this.javaIndex = javaIndex;
    }

    public EnchantOptionData build(GeyserSession session) {
        this.hasChanged = false;
        return new EnchantOptionData(this.xpCost, this.javaIndex + 16, EMPTY, this.enchantLevel == -1 ? EMPTY : Collections.singletonList(new EnchantData(this.bedrockEnchantIndex, this.enchantLevel)), EMPTY, this.bedrockEnchantIndex == -1 ? "unknown" : ENCHANT_NAMES.get(this.bedrockEnchantIndex), this.enchantLevel == -1 ? 0 : session.getNextItemNetId());
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setXpCost(int xpCost) {
        if (this.xpCost != xpCost) {
            this.hasChanged = true;
            this.xpCost = xpCost;
        }
    }

    public void setEnchantIndex(int bedrockEnchantIndex) {
        if (this.bedrockEnchantIndex != bedrockEnchantIndex) {
            this.hasChanged = true;
            this.bedrockEnchantIndex = bedrockEnchantIndex;
        }
    }

    public void setEnchantLevel(int enchantLevel) {
        if (this.enchantLevel != enchantLevel) {
            this.hasChanged = true;
            this.enchantLevel = enchantLevel;
        }
    }

    @Generated
    public int getJavaIndex() {
        return this.javaIndex;
    }
}

