/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.item.custom.v2.component.java;

import java.util.function.Predicate;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.java.AttackRange;
import org.geysermc.geyser.api.item.custom.v2.component.java.Consumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.Equippable;
import org.geysermc.geyser.api.item.custom.v2.component.java.FoodProperties;
import org.geysermc.geyser.api.item.custom.v2.component.java.KineticWeapon;
import org.geysermc.geyser.api.item.custom.v2.component.java.PiercingWeapon;
import org.geysermc.geyser.api.item.custom.v2.component.java.Repairable;
import org.geysermc.geyser.api.item.custom.v2.component.java.SwingAnimation;
import org.geysermc.geyser.api.item.custom.v2.component.java.ToolProperties;
import org.geysermc.geyser.api.item.custom.v2.component.java.UseCooldown;
import org.geysermc.geyser.api.item.custom.v2.component.java.UseEffects;
import org.geysermc.geyser.api.util.Identifier;

public interface ItemDataComponents {
    public static final DataComponent<Consumable> CONSUMABLE = ItemDataComponents.create("consumable");
    public static final DataComponent<Equippable> EQUIPPABLE = ItemDataComponents.create("equippable");
    public static final DataComponent<FoodProperties> FOOD = ItemDataComponents.create("food");
    public static final DataComponent<Integer> MAX_DAMAGE = ItemDataComponents.create("max_damage", i -> i >= 0);
    public static final DataComponent<Integer> MAX_STACK_SIZE = ItemDataComponents.create("max_stack_size", i -> i >= 1 && i <= 99);
    public static final DataComponent<UseCooldown> USE_COOLDOWN = ItemDataComponents.create("use_cooldown");
    public static final DataComponent<Integer> ENCHANTABLE = ItemDataComponents.create("enchantable", i -> i >= 0);
    public static final DataComponent<ToolProperties> TOOL = ItemDataComponents.create("tool");
    public static final DataComponent<Repairable> REPAIRABLE = ItemDataComponents.create("repairable");
    public static final DataComponent<Boolean> ENCHANTMENT_GLINT_OVERRIDE = ItemDataComponents.create("enchantment_glint_override");
    public static final DataComponent<AttackRange> ATTACK_RANGE = ItemDataComponents.create("attack_range");
    public static final DataComponent<KineticWeapon> KINETIC_WEAPON = ItemDataComponents.create("kinetic_weapon");
    public static final DataComponent<PiercingWeapon> PIERCING_WEAPON = ItemDataComponents.create("piercing_weapon");
    public static final DataComponent<SwingAnimation> SWING_ANIMATION = ItemDataComponents.create("swing_animation");
    public static final DataComponent<UseEffects> USE_EFFECTS = ItemDataComponents.create("use_effects");

    private static <T> DataComponent<T> create(String id) {
        return ItemDataComponents.create(id, t -> true);
    }

    private static <T> DataComponent<T> create(String id, Predicate<T> consumer) {
        return (DataComponent)GeyserApi.api().provider(DataComponent.class, Identifier.of(id), consumer, true);
    }
}

