/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundSetPlayerInventoryPacket;

@Translator(packet=ClientboundSetPlayerInventoryPacket.class)
public class JavaSetPlayerInventoryTranslator
extends PacketTranslator<ClientboundSetPlayerInventoryPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetPlayerInventoryPacket packet) {
        int slot = packet.getSlot();
        if (slot == 41 || slot == 42) {
            return;
        }
        if (slot >= 0 && slot <= 8) {
            slot = session.getPlayerInventory().getOffsetForHotbar(slot);
        }
        if (slot >= session.getPlayerInventory().getSize()) {
            GeyserLogger logger = session.getGeyser().getLogger();
            logger.warning("ClientboundSetPlayerInventoryPacket sent to " + session.bedrockUsername() + " that exceeds inventory size!");
            if (logger.isDebug()) {
                logger.debug(packet.toString());
                logger.debug(session.getPlayerInventory().toString());
            }
            return;
        }
        GeyserItemStack newItem = GeyserItemStack.from(session, packet.getContents());
        session.getBundleCache().initialize(newItem);
        session.getPlayerInventory().setItem(slot, newItem, session);
        session.getPlayerInventoryHolder().updateSlot(slot);
    }
}

