/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import java.util.Locale;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ToastRequestPacket;
import org.geysermc.geyser.level.GeyserAdvancement;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.AdvancementsCache;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.advancement.Advancement;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundUpdateAdvancementsPacket;

@Translator(packet=ClientboundUpdateAdvancementsPacket.class)
public class JavaUpdateAdvancementsTranslator
extends PacketTranslator<ClientboundUpdateAdvancementsPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundUpdateAdvancementsPacket packet) {
        AdvancementsCache advancementsCache = session.getAdvancementsCache();
        if (packet.isReset()) {
            advancementsCache.getStoredAdvancements().clear();
            advancementsCache.getStoredAdvancementProgress().clear();
        }
        for (String string : packet.getRemovedAdvancements()) {
            advancementsCache.getStoredAdvancements().remove(string);
        }
        advancementsCache.getStoredAdvancementProgress().putAll(packet.getProgress());
        for (String string : packet.getAdvancements()) {
            if (string.getDisplayData() != null && (!string.getDisplayData().isHidden() || string.getDisplayData().isShowToast())) {
                GeyserAdvancement geyserAdvancement = GeyserAdvancement.from((Advancement)string);
                advancementsCache.getStoredAdvancements().put(string.getId(), geyserAdvancement);
                continue;
            }
            advancementsCache.getStoredAdvancements().remove(string.getId());
        }
        this.sendAdvancementToasts(session, packet);
    }

    public void sendAdvancementToasts(GeyserSession session, ClientboundUpdateAdvancementsPacket packet) {
        if (packet.isReset()) {
            return;
        }
        for (String advancementId : packet.getProgress().keySet()) {
            GeyserAdvancement advancement = session.getAdvancementsCache().getStoredAdvancements().get(advancementId);
            if (advancement == null || advancement.getDisplayData() == null || !advancement.getDisplayData().isShowToast() || !session.getAdvancementsCache().isEarned(advancement)) continue;
            String frameType = advancement.getDisplayData().getAdvancementType().toString().toLowerCase(Locale.ROOT);
            String frameTitle = advancement.getDisplayColor() + MinecraftLocale.getLocaleString("advancements.toast." + frameType, session.locale());
            String advancementName = MessageTranslator.convertMessage(advancement.getDisplayData().getTitle(), session.locale());
            ToastRequestPacket toastRequestPacket = new ToastRequestPacket();
            toastRequestPacket.setTitle((CharSequence)frameTitle);
            toastRequestPacket.setContent((CharSequence)advancementName);
            session.sendUpstreamPacket((BedrockPacket)toastRequestPacket);
        }
    }
}

