/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import java.util.Arrays;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;

public class BlockCollision {
    protected final BoundingBox[] boundingBoxes;
    protected final double pushAwayTolerance = 1.1000000000000001E-5;

    protected BlockCollision(BoundingBox[] boxes) {
        this.boundingBoxes = boxes;
    }

    public void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        double collisionExpansion = 2.0E-5;
        playerCollision.expand(2.0E-5, 0.0, 2.0E-5);
        for (BoundingBox boundingBox : this.boundingBoxes) {
            if (!boundingBox.checkIntersection(x, y, z, playerCollision)) continue;
            boundingBox = boundingBox.clone();
            boundingBox.translate(x, y, z);
            double xULP = Math.ulp((float)Math.max(Math.abs(playerCollision.getMiddleX()) + playerCollision.getSizeX() / 2.0, (double)(Math.abs(x) + 1)));
            double zULP = Math.ulp((float)Math.max(Math.abs(playerCollision.getMiddleZ()) + playerCollision.getSizeZ() / 2.0, (double)(Math.abs(z) + 1)));
            double xPushAwayTolerance = Math.max(1.1000000000000001E-5, xULP);
            double zPushAwayTolerance = Math.max(1.1000000000000001E-5, zULP);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.NORTH, zPushAwayTolerance);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.SOUTH, zPushAwayTolerance);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.EAST, xPushAwayTolerance);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.WEST, xPushAwayTolerance);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.UP, 1.1000000000000001E-5);
            boundingBox.pushOutOfBoundingBox(playerCollision, Direction.DOWN, 1.1000000000000001E-5);
            this.correctPosition(session, x, y, z, boundingBox, playerCollision, xPushAwayTolerance, zPushAwayTolerance);
        }
        playerCollision.expand(-2.0E-5, 0.0, -2.0E-5);
    }

    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision, double ulpX, double ulpZ) {
    }

    public boolean checkIntersection(double x, double y, double z, BoundingBox playerCollision) {
        for (BoundingBox b : this.boundingBoxes) {
            if (!b.checkIntersection(x, y, z, playerCollision)) continue;
            return true;
        }
        return false;
    }

    public boolean checkIntersection(Vector3i position, BoundingBox playerCollision) {
        return this.checkIntersection(position.getX(), position.getY(), position.getZ(), playerCollision);
    }

    public double computeCollisionOffset(double x, double y, double z, BoundingBox boundingBox, Axis axis, double offset) {
        for (BoundingBox b : this.boundingBoxes) {
            if (!(Math.abs(offset = b.getMaxOffset(x, y, z, boundingBox, axis, offset)) < 1.0E-5)) continue;
            return 0.0;
        }
        return offset;
    }

    public boolean isBelow(int blockY, BoundingBox boundingBox) {
        double minY = boundingBox.getMiddleY() - boundingBox.getSizeY() / 2.0;
        for (BoundingBox b : this.boundingBoxes) {
            double offset = (double)blockY + b.getMiddleY() + b.getSizeY() / 2.0 - minY;
            if (!(offset > 1.0E-5)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCollision)) {
            return false;
        }
        BlockCollision other = (BlockCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.pushAwayTolerance, other.pushAwayTolerance) != 0) {
            return false;
        }
        return Arrays.deepEquals(this.getBoundingBoxes(), other.getBoundingBoxes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockCollision;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pushAwayTolerance = Double.doubleToLongBits(this.pushAwayTolerance);
        result = result * 59 + (int)($pushAwayTolerance >>> 32 ^ $pushAwayTolerance);
        result = result * 59 + Arrays.deepHashCode(this.getBoundingBoxes());
        return result;
    }

    @Generated
    public BoundingBox[] getBoundingBoxes() {
        return this.boundingBoxes;
    }
}

