/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class EntityEffectCache {
    private final Set<Effect> entityEffects = EnumSet.noneOf(Effect.class);
    private int conduitPower;
    private int haste;
    private int miningFatigue;
    private int jumpPower;

    public void setEffect(Effect effect, int effectAmplifier) {
        switch (effect) {
            case CONDUIT_POWER: {
                this.conduitPower = effectAmplifier + 1;
                break;
            }
            case HASTE: {
                this.haste = effectAmplifier + 1;
                break;
            }
            case MINING_FATIGUE: {
                this.miningFatigue = effectAmplifier + 1;
                break;
            }
            case JUMP_BOOST: {
                this.jumpPower = effectAmplifier + 1;
            }
        }
        this.entityEffects.add(effect);
    }

    public void removeEffect(Effect effect) {
        switch (effect) {
            case CONDUIT_POWER: {
                this.conduitPower = 0;
                break;
            }
            case HASTE: {
                this.haste = 0;
                break;
            }
            case MINING_FATIGUE: {
                this.miningFatigue = 0;
                break;
            }
            case JUMP_BOOST: {
                this.jumpPower = 0;
            }
        }
        this.entityEffects.remove(effect);
    }

    @Generated
    public Set<Effect> getEntityEffects() {
        return this.entityEffects;
    }

    @Generated
    public int getConduitPower() {
        return this.conduitPower;
    }

    @Generated
    public int getHaste() {
        return this.haste;
    }

    @Generated
    public int getMiningFatigue() {
        return this.miningFatigue;
    }

    @Generated
    public int getJumpPower() {
        return this.jumpPower;
    }
}

