/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.network.GeyserBedrockPeer;

public class UpstreamSession {
    private final BedrockServerSession session;
    private boolean initialized = false;
    private Queue<BedrockPacket> postStartGamePackets = new ArrayDeque<BedrockPacket>();

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (!this.isClosed()) {
            this.session.sendPacket(packet);
        }
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (!this.isClosed()) {
            this.session.sendPacketImmediately(packet);
        }
    }

    public void disconnect(String reason) {
        this.session.disconnect((CharSequence)reason);
    }

    public void queuePostStartGamePacket(BedrockPacket packet) {
        this.postStartGamePackets.add(packet);
    }

    public void sendPostStartGamePackets() {
        BedrockPacket packet;
        if (this.isClosed()) {
            return;
        }
        while ((packet = this.postStartGamePackets.poll()) != null) {
            this.session.sendPacket(packet);
        }
        this.postStartGamePackets = null;
    }

    public boolean isClosed() {
        return !this.session.getPeer().isConnected() && !this.session.getPeer().isConnecting();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)((GeyserBedrockPeer)this.session.getPeer()).getRealAddress();
    }

    public int getProtocolVersion() {
        return this.session.getCodec().getProtocolVersion();
    }

    public BedrockCodecHelper getCodecHelper() {
        return this.session.getPeer().getCodecHelper();
    }

    public void forciblyClose() {
        this.session.getPeer().getChannel().close();
    }

    @Generated
    public UpstreamSession(BedrockServerSession session) {
        this.session = session;
    }

    @Generated
    public BedrockServerSession getSession() {
        return this.session;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

