/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public final class SessionManager {
    private final Set<GeyserSession> pendingSessions = ConcurrentHashMap.newKeySet();
    private final Map<UUID, GeyserSession> sessions = new ConcurrentHashMap<UUID, GeyserSession>();
    private final Map<InetAddress, AtomicInteger> connectedClients = new ConcurrentHashMap<InetAddress, AtomicInteger>();
    private static final int MAX_CONNECTIONS_PER_ADDRESS = Integer.getInteger("Geyser.MaxConnectionsPerAddress", 10);

    public boolean reachedMaxConnectionsPerAddress(GeyserSession session) {
        return this.getAddressMultiplier(session.getSocketAddress().getAddress()) > MAX_CONNECTIONS_PER_ADDRESS;
    }

    public void addPendingSession(GeyserSession session) {
        this.pendingSessions.add(session);
        this.connectedClients.compute(session.getSocketAddress().getAddress(), (key, count) -> {
            if (count == null) {
                return new AtomicInteger(1);
            }
            count.incrementAndGet();
            return count;
        });
    }

    public void addSession(UUID uuid, GeyserSession session) {
        this.pendingSessions.remove(session);
        this.sessions.put(uuid, session);
    }

    public void removeSession(GeyserSession session) {
        UUID uuid = session.getPlayerEntity().uuid();
        if (uuid == null || this.sessions.remove(uuid) == null) {
            this.pendingSessions.remove(session);
        }
        this.connectedClients.computeIfPresent(session.getSocketAddress().getAddress(), (key, count) -> {
            if (count.decrementAndGet() <= 0) {
                return null;
            }
            return count;
        });
    }

    public int getAddressMultiplier(InetAddress ip) {
        AtomicInteger atomicInteger = this.connectedClients.get(ip);
        return atomicInteger == null ? 1 : atomicInteger.get();
    }

    public boolean isXuidAlreadyPending(String xuid) {
        for (GeyserSession session : this.pendingSessions) {
            if (!session.xuid().equals(xuid)) continue;
            return true;
        }
        return false;
    }

    public @Nullable GeyserSession sessionByXuid(@NonNull String xuid) {
        Objects.requireNonNull(xuid);
        for (GeyserSession session : this.sessions.values()) {
            if (!session.xuid().equals(xuid)) continue;
            return session;
        }
        return null;
    }

    public List<GeyserSession> getAllSessions() {
        return ImmutableList.builder().addAll(this.pendingSessions).addAll(this.sessions.values()).build();
    }

    public void disconnectAll(String message) {
        List<GeyserSession> sessions = this.getAllSessions();
        for (GeyserSession session : sessions) {
            session.disconnect(GeyserLocale.getPlayerLocaleString(message, session.locale()));
        }
    }

    public int size() {
        return this.pendingSessions.size() + this.sessions.size();
    }

    @Generated
    Set<GeyserSession> getPendingSessions() {
        return this.pendingSessions;
    }

    @Generated
    public Map<UUID, GeyserSession> getSessions() {
        return this.sessions;
    }

    @Generated
    Map<InetAddress, AtomicInteger> getConnectedClients() {
        return this.connectedClients;
    }
}

