/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.definition.ItemDefinitionReaders;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;
import org.geysermc.geyser.registry.mappings.versions.MappingsReader;

public class MappingsReader_v2
extends MappingsReader {
    @Override
    public void readItemMappings(Path file, JsonObject mappingsRoot, BiConsumer<Identifier, CustomItemDefinition> consumer) {
        this.readItemMappingsV2(file, mappingsRoot, consumer);
    }

    public void readItemMappingsV2(Path file, JsonObject mappingsRoot, BiConsumer<Identifier, CustomItemDefinition> consumer) {
        JsonObject items = mappingsRoot.getAsJsonObject("items");
        if (items != null) {
            items.entrySet().forEach(entry -> {
                Object patt2384$temp = entry.getValue();
                if (patt2384$temp instanceof JsonArray) {
                    JsonArray array = (JsonArray)patt2384$temp;
                    array.forEach(definition -> {
                        try {
                            Identifier vanillaItem = Identifier.of((String)entry.getKey());
                            ItemDefinitionReaders.readDefinition(definition, vanillaItem, null, consumer, "item definition(s) for vanilla Java item " + String.valueOf(vanillaItem));
                        }
                        catch (InvalidCustomMappingsFileException exception) {
                            GeyserImpl.getInstance().getLogger().error("Error reading definition(s) for vanilla Java item " + (String)entry.getKey() + " in custom mappings file: " + file.toString(), exception);
                        }
                    });
                } else {
                    GeyserImpl.getInstance().getLogger().error("Item definitions key " + (String)entry.getKey() + " was not an array!");
                }
            });
        }
    }

    @Override
    public void readBlockMappings(Path file, JsonObject mappingsRoot, BiConsumer<String, CustomBlockMapping> consumer) {
        JsonElement blocks = mappingsRoot.get("blocks");
        if (blocks != null) {
            throw new UnsupportedOperationException("Unimplemented; use the v1 format for block mappings");
        }
    }

    @Override
    public CustomItemDefinition readItemMappingEntry(Identifier parentModel, JsonElement element) {
        throw new UnsupportedOperationException("Replaced by ItemDefinitionReaders enum");
    }

    @Override
    public CustomBlockMapping readBlockMappingEntry(String identifier, JsonElement node) throws InvalidCustomMappingsFileException {
        throw new InvalidCustomMappingsFileException("Unimplemented; use the v1 format for block mappings");
    }
}

