/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components.readers;

import com.google.gson.JsonElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaKineticWeapon;
import org.geysermc.geyser.item.custom.impl.JavaKineticWeaponImpl;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class KineticWeaponReader
extends DataComponentReader<JavaKineticWeapon> {
    public KineticWeaponReader() {
        super(JavaItemDataComponents.KINETIC_WEAPON);
    }

    @Override
    protected JavaKineticWeapon readDataComponent(@NonNull JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        return new JavaKineticWeaponImpl(MappingsUtil.readOrDefault(element, "delay_ticks", NodeReader.NON_NEGATIVE_INT, 0, context), KineticWeaponReader.readCondition(element, "dismount_conditions", context));
    }

    private static @Nullable JavaKineticWeapon.Condition readCondition(@NonNull JsonElement element, String name, String ... context) throws InvalidCustomMappingsFileException {
        JsonElement condition = element.getAsJsonObject().get(name);
        if (condition == null) {
            return null;
        }
        return new JavaKineticWeaponImpl.ConditionImpl(MappingsUtil.readOrThrow(element, "max_duration_ticks", NodeReader.NON_NEGATIVE_INT, context), MappingsUtil.readOrDefault(element, "min_speed", NodeReader.FLOAT, Float.valueOf(0.0f), context).floatValue(), MappingsUtil.readOrDefault(element, "min_relative_speed", NodeReader.FLOAT, Float.valueOf(0.0f), context).floatValue());
    }
}

