/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.option;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.exception.ResourcePackException;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.api.pack.option.SubpackOption;

public record GeyserSubpackOption(String subpackName) implements SubpackOption
{
    @Override
    public @NonNull ResourcePackOption.Type type() {
        return ResourcePackOption.Type.SUBPACK;
    }

    @Override
    public @NonNull String value() {
        return this.subpackName;
    }

    @Override
    public void validate(@NonNull ResourcePack pack) {
        Objects.requireNonNull(pack);
        if (this.subpackName.isEmpty()) {
            return;
        }
        if (pack.manifest().subpacks().stream().noneMatch(subpack -> subpack.name().equals(this.subpackName))) {
            throw new ResourcePackException(ResourcePackException.Cause.INVALID_PACK_OPTION, "No subpack with the name %s found!".formatted(this.subpackName));
        }
    }
}

