/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import java.util.function.ToIntFunction;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.physics.Axis;

public enum Direction {
    DOWN(1, Vector3i.from((int)0, (int)-1, (int)0), Axis.Y, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.DOWN),
    UP(0, Vector3i.UNIT_Y, Axis.Y, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.UP),
    NORTH(3, Vector3i.from((int)0, (int)0, (int)-1), Axis.Z, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.NORTH),
    SOUTH(2, Vector3i.UNIT_Z, Axis.Z, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.SOUTH),
    WEST(5, Vector3i.from((int)-1, (int)0, (int)0), Axis.X, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.WEST),
    EAST(4, Vector3i.UNIT_X, Axis.X, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction.EAST);

    public static final Direction[] VALUES;
    public static final Direction[] HORIZONTAL;
    private final int reversedId;
    private final Vector3i unitVector;
    private final Axis axis;
    private final org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction mcpl;

    private Direction(int reversedId, Vector3i unitVector, Axis axis, org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction mcpl) {
        this.reversedId = reversedId;
        this.unitVector = unitVector;
        this.axis = axis;
        this.mcpl = mcpl;
    }

    public Direction reversed() {
        return VALUES[this.reversedId];
    }

    public boolean isVertical() {
        return this.axis == Axis.Y;
    }

    public boolean isHorizontal() {
        return this.axis == Axis.X || this.axis == Axis.Z;
    }

    public Direction clockWise() {
        return switch (this) {
            case NORTH -> EAST;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            case EAST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get CW facing of " + String.valueOf((Object)this));
        };
    }

    public Direction counterClockWise() {
        return switch (this) {
            case NORTH -> WEST;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            case EAST -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf((Object)this));
        };
    }

    public static @NonNull Direction fromMCPL(org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction mcpl) {
        for (Direction direction : VALUES) {
            if (direction.mcpl != mcpl) continue;
            return direction;
        }
        throw new IllegalStateException();
    }

    public static <T> Direction getUntrusted(T source, ToIntFunction<T> idExtractor) {
        int id = idExtractor.applyAsInt(source);
        if (id < 0 || id >= VALUES.length) {
            GeyserImpl.getInstance().getLogger().warning("Received invalid direction from " + String.valueOf(source) + " (ID was " + id + ")");
            return DOWN;
        }
        return VALUES[id];
    }

    @Generated
    public Vector3i getUnitVector() {
        return this.unitVector;
    }

    @Generated
    public Axis getAxis() {
        return this.axis;
    }

    @Generated
    public org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction mcpl() {
        return this.mcpl;
    }

    static {
        VALUES = Direction.values();
        HORIZONTAL = new Direction[]{NORTH, EAST, SOUTH, WEST};
    }
}

