/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.type.ArrowItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public class TippedArrowItem
extends ArrowItem {
    public TippedArrowItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(GeyserSession session, int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        PotionContents potionContents;
        if (components != null && (potionContents = (PotionContents)components.get(DataComponentTypes.POTION_CONTENTS)) != null) {
            Potion potion = Potion.getByJavaId(potionContents.getPotionId());
            if (potion != null) {
                return ItemData.builder().definition(mapping.getBedrockDefinition()).damage(potion.tippedArrowId()).count(count);
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown Java potion (tipped arrow): " + potionContents.getPotionId());
        }
        return super.translateToBedrock(session, count, components, mapping, mappings);
    }
}

