/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl.predicates;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.RangeDispatchPredicate;
import org.geysermc.geyser.impl.GeyserCoreProvided;

@GeyserCoreProvided
public record GeyserRangeDispatchPredicate(@NonNull GeyserRangeDispatchProperty rangeProperty, double threshold, @NonNegative int index, boolean normalized, boolean negated) implements RangeDispatchPredicate
{
    public GeyserRangeDispatchPredicate(@NonNull GeyserRangeDispatchProperty rangeProperty, double threshold, @NonNegative int index, boolean normalized, boolean negated) {
        Objects.requireNonNull(rangeProperty, "range property cannot be null");
        if (index < 0) {
            throw new IllegalArgumentException("Negative index: " + index);
        }
    }

    public GeyserRangeDispatchPredicate(GeyserRangeDispatchProperty property, double threshold, boolean normalized) {
        this(property, threshold, 0, normalized, false);
    }

    public GeyserRangeDispatchPredicate(GeyserRangeDispatchProperty property, double threshold, int index) {
        this(property, threshold, index, false, false);
    }

    public GeyserRangeDispatchPredicate(GeyserRangeDispatchProperty property, double threshold) {
        this(property, threshold, 0, false, false);
    }

    @Override
    public @NonNull RangeDispatchPredicate.Property property() {
        return RangeDispatchPredicate.Property.valueOf(this.rangeProperty.name());
    }

    @Override
    public boolean test(ItemPredicateContext context) {
        Number value = this.rangeProperty.getter.apply(context, this);
        if (this.normalized) {
            if (value == null || this.rangeProperty.maxGetter == null) {
                return false;
            }
            Number max = this.rangeProperty.maxGetter.apply(context);
            if (max == null || max.doubleValue() == 0.0) {
                return false;
            }
            value = value.doubleValue() / max.doubleValue();
        }
        return this.negated ? value.doubleValue() < this.threshold : value.doubleValue() >= this.threshold;
    }

    @Override
    public @NonNull MinecraftPredicate<ItemPredicateContext> negate() {
        return new GeyserRangeDispatchPredicate(this.rangeProperty, this.threshold, this.index, this.normalized, !this.negated);
    }

    public static enum GeyserRangeDispatchProperty {
        BUNDLE_FULLNESS(ItemPredicateContext::bundleFullness),
        DAMAGE(ItemPredicateContext::damage, ItemPredicateContext::maxDamage),
        COUNT(ItemPredicateContext::count, ItemPredicateContext::maxStackSize),
        CUSTOM_MODEL_DATA((context, predicate) -> Float.valueOf(context.customModelDataFloat(predicate.index())));

        private final BiFunction<ItemPredicateContext, RangeDispatchPredicate, Number> getter;
        private final Function<ItemPredicateContext, Number> maxGetter;

        private GeyserRangeDispatchProperty(BiFunction<ItemPredicateContext, RangeDispatchPredicate, Number> getter, Function<ItemPredicateContext, Number> maxGetter) {
            this.getter = getter;
            this.maxGetter = maxGetter;
        }

        private GeyserRangeDispatchProperty(BiFunction<ItemPredicateContext, RangeDispatchPredicate, Number> getter) {
            this(getter, null);
        }

        private GeyserRangeDispatchProperty(Function<ItemPredicateContext, Number> getter, Function<ItemPredicateContext, Number> maxGetter) {
            this((ItemPredicateContext context, RangeDispatchPredicate rangeDispatchPredicate) -> (Number)getter.apply((ItemPredicateContext)context), maxGetter);
        }

        private GeyserRangeDispatchProperty(Function<ItemPredicateContext, Number> getter) {
            this((ItemPredicateContext context, RangeDispatchPredicate rangeDispatchPredicate) -> (Number)getter.apply((ItemPredicateContext)context), null);
        }
    }
}

