/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponentMap;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.PredicateStrategy;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.util.GeyserProvided;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.impl.GeyserCoreProvided;
import org.geysermc.geyser.item.custom.GeyserNonVanillaCustomItemDefinition;
import org.geysermc.geyser.item.custom.impl.ItemDataComponentImpl;
import org.geysermc.geyser.util.AnnotationUtils;

public class GeyserCustomItemDefinition
implements CustomItemDefinition {
    private final @NonNull Identifier bedrockIdentifier;
    private final @NonNull String displayName;
    private final @NonNull Identifier model;
    private final @NonNull String icon;
    private final @NonNull List<MinecraftPredicate<? super ItemPredicateContext>> predicates;
    private final PredicateStrategy predicateStrategy;
    private final int priority;
    private final @NonNull CustomItemBedrockOptions bedrockOptions;
    private final @NonNull ItemDataComponentMap components;
    private final @NonNull List<Identifier> removedComponents;
    private final CustomRenderOffsets renderOffsets;
    private final boolean isOldConvertedItem;
    private final int textureSize;

    public GeyserCustomItemDefinition(Builder builder) {
        this.bedrockIdentifier = builder.bedrockIdentifier;
        this.displayName = builder.displayName;
        this.model = builder.model;
        String setIcon = builder.bedrockOptions.icon();
        this.icon = setIcon == null ? this.bedrockIdentifier().toString().replaceAll(":", ".").replaceAll("/", "_") : setIcon;
        this.predicates = List.copyOf(builder.predicates);
        this.predicateStrategy = builder.predicateStrategy;
        this.priority = builder.priority;
        this.bedrockOptions = builder.bedrockOptions;
        this.components = new ComponentMapItem(builder.components);
        this.removedComponents = builder.removedComponents;
        this.renderOffsets = builder.renderOffsets;
        this.textureSize = builder.textureSize;
        this.isOldConvertedItem = builder.isOldConvertedItem;
    }

    @Override
    public @NonNull Identifier bedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    @Override
    public @NonNull String displayName() {
        return this.displayName;
    }

    @Override
    public @NonNull Identifier model() {
        return this.model;
    }

    @Override
    public @NonNull String icon() {
        return this.icon;
    }

    @Override
    public @NonNull List<MinecraftPredicate<? super ItemPredicateContext>> predicates() {
        return this.predicates;
    }

    @Override
    public @NonNull PredicateStrategy predicateStrategy() {
        return this.predicateStrategy;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public @NonNull CustomItemBedrockOptions bedrockOptions() {
        return this.bedrockOptions;
    }

    @Override
    public @NonNull ItemDataComponentMap components() {
        return this.components;
    }

    @Override
    public @NonNull List<Identifier> removedComponents() {
        return this.removedComponents;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomItemDefinition)) {
            return false;
        }
        GeyserCustomItemDefinition other = (GeyserCustomItemDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.isOldConvertedItem() != other.isOldConvertedItem()) {
            return false;
        }
        if (this.getTextureSize() != other.getTextureSize()) {
            return false;
        }
        Identifier this$bedrockIdentifier = this.bedrockIdentifier;
        Identifier other$bedrockIdentifier = other.bedrockIdentifier;
        if (this$bedrockIdentifier == null ? other$bedrockIdentifier != null : !this$bedrockIdentifier.equals(other$bedrockIdentifier)) {
            return false;
        }
        String this$displayName = this.displayName;
        String other$displayName = other.displayName;
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Identifier this$model = this.model;
        Identifier other$model = other.model;
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$icon = this.icon;
        String other$icon = other.icon;
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List<MinecraftPredicate<? super ItemPredicateContext>> this$predicates = this.predicates;
        List<MinecraftPredicate<? super ItemPredicateContext>> other$predicates = other.predicates;
        if (this$predicates == null ? other$predicates != null : !((Object)this$predicates).equals(other$predicates)) {
            return false;
        }
        PredicateStrategy this$predicateStrategy = this.predicateStrategy;
        PredicateStrategy other$predicateStrategy = other.predicateStrategy;
        if (this$predicateStrategy == null ? other$predicateStrategy != null : !((Object)((Object)this$predicateStrategy)).equals((Object)other$predicateStrategy)) {
            return false;
        }
        CustomItemBedrockOptions this$bedrockOptions = this.bedrockOptions;
        CustomItemBedrockOptions other$bedrockOptions = other.bedrockOptions;
        if (this$bedrockOptions == null ? other$bedrockOptions != null : !this$bedrockOptions.equals(other$bedrockOptions)) {
            return false;
        }
        ItemDataComponentMap this$components = this.components;
        ItemDataComponentMap other$components = other.components;
        if (this$components == null ? other$components != null : !this$components.equals(other$components)) {
            return false;
        }
        List<Identifier> this$removedComponents = this.removedComponents;
        List<Identifier> other$removedComponents = other.removedComponents;
        if (this$removedComponents == null ? other$removedComponents != null : !((Object)this$removedComponents).equals(other$removedComponents)) {
            return false;
        }
        CustomRenderOffsets this$renderOffsets = this.getRenderOffsets();
        CustomRenderOffsets other$renderOffsets = other.getRenderOffsets();
        return !(this$renderOffsets == null ? other$renderOffsets != null : !((Object)this$renderOffsets).equals(other$renderOffsets));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeyserCustomItemDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.priority;
        result = result * 59 + (this.isOldConvertedItem() ? 79 : 97);
        result = result * 59 + this.getTextureSize();
        Identifier $bedrockIdentifier = this.bedrockIdentifier;
        result = result * 59 + ($bedrockIdentifier == null ? 43 : $bedrockIdentifier.hashCode());
        String $displayName = this.displayName;
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Identifier $model = this.model;
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $icon = this.icon;
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List<MinecraftPredicate<? super ItemPredicateContext>> $predicates = this.predicates;
        result = result * 59 + ($predicates == null ? 43 : ((Object)$predicates).hashCode());
        PredicateStrategy $predicateStrategy = this.predicateStrategy;
        result = result * 59 + ($predicateStrategy == null ? 43 : ((Object)((Object)$predicateStrategy)).hashCode());
        CustomItemBedrockOptions $bedrockOptions = this.bedrockOptions;
        result = result * 59 + ($bedrockOptions == null ? 43 : $bedrockOptions.hashCode());
        ItemDataComponentMap $components = this.components;
        result = result * 59 + ($components == null ? 43 : $components.hashCode());
        List<Identifier> $removedComponents = this.removedComponents;
        result = result * 59 + ($removedComponents == null ? 43 : ((Object)$removedComponents).hashCode());
        CustomRenderOffsets $renderOffsets = this.getRenderOffsets();
        result = result * 59 + ($renderOffsets == null ? 43 : ((Object)$renderOffsets).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeyserCustomItemDefinition(bedrockIdentifier=" + String.valueOf(this.bedrockIdentifier) + ", displayName=" + this.displayName + ", model=" + String.valueOf(this.model) + ", icon=" + this.icon + ", predicates=" + String.valueOf(this.predicates) + ", predicateStrategy=" + String.valueOf((Object)this.predicateStrategy) + ", priority=" + this.priority + ", bedrockOptions=" + String.valueOf(this.bedrockOptions) + ", components=" + String.valueOf(this.components) + ", removedComponents=" + String.valueOf(this.removedComponents) + ", renderOffsets=" + String.valueOf(this.getRenderOffsets()) + ", isOldConvertedItem=" + this.isOldConvertedItem() + ", textureSize=" + this.getTextureSize() + ")";
    }

    @Generated
    public CustomRenderOffsets getRenderOffsets() {
        return this.renderOffsets;
    }

    @Generated
    public boolean isOldConvertedItem() {
        return this.isOldConvertedItem;
    }

    @Generated
    public int getTextureSize() {
        return this.textureSize;
    }

    public static class Builder
    implements CustomItemDefinition.Builder {
        private final Identifier bedrockIdentifier;
        private final Identifier model;
        private final List<MinecraftPredicate<? super ItemPredicateContext>> predicates = new ArrayList<MinecraftPredicate<? super ItemPredicateContext>>();
        private final Reference2ObjectMap<ItemDataComponent<?>, Object> components = new Reference2ObjectOpenHashMap();
        private final List<Identifier> removedComponents = new ArrayList<Identifier>();
        private String displayName;
        private int priority = 0;
        private CustomItemBedrockOptions bedrockOptions = CustomItemBedrockOptions.builder().build();
        private PredicateStrategy predicateStrategy = PredicateStrategy.AND;
        private CustomRenderOffsets renderOffsets;
        private boolean isOldConvertedItem = false;
        private int textureSize = 16;

        public Builder(@NonNull Identifier bedrockIdentifier, @NonNull Identifier model) {
            Objects.requireNonNull(bedrockIdentifier, "bedrockIdentifier cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            this.bedrockIdentifier = bedrockIdentifier;
            this.displayName = bedrockIdentifier.toString();
            this.model = model;
        }

        @Override
        public CustomItemDefinition.Builder displayName(@NonNull String displayName) {
            Objects.requireNonNull(displayName, "displayName cannot be null");
            this.displayName = displayName;
            return this;
        }

        @Override
        public CustomItemDefinition.Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public CustomItemDefinition.Builder bedrockOptions(@NonNull CustomItemBedrockOptions.Builder options) {
            Objects.requireNonNull(options, "options cannot be null");
            this.bedrockOptions = options.build();
            return this;
        }

        @Override
        public CustomItemDefinition.Builder predicate(@NonNull MinecraftPredicate<? super ItemPredicateContext> predicate) {
            Objects.requireNonNull(predicate, "predicate cannot be null");
            boolean isApiProvided = AnnotationUtils.hasAnnotationRecursive(predicate.getClass(), GeyserProvided.class);
            boolean isCoreImpl = AnnotationUtils.hasAnnotationRecursive(predicate.getClass(), GeyserCoreProvided.class);
            if (isApiProvided && !isCoreImpl) {
                throw new IllegalArgumentException("Found custom implementation (%s) of Geyser-provided predicate! Use the predicate creators provided in the api instead.".formatted(predicate.getClass().getName()));
            }
            this.predicates.add(predicate);
            return this;
        }

        @Override
        public CustomItemDefinition.Builder predicateStrategy(@NonNull PredicateStrategy strategy) {
            Objects.requireNonNull(strategy, "strategy cannot be null");
            this.predicateStrategy = strategy;
            return this;
        }

        @Override
        public <T> CustomItemDefinition.Builder component(@NonNull ItemDataComponent<T> component, @NonNull T value) {
            Objects.requireNonNull(component, "component cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            if (!(component instanceof ItemDataComponentImpl)) {
                throw new IllegalArgumentException("Cannot use custom implementations of the DataComponent<T> interface! Found: " + component.getClass().getSimpleName());
            }
            ItemDataComponentImpl dataComponent = (ItemDataComponentImpl)component;
            if (this.removedComponents.contains(component.identifier())) {
                throw new IllegalArgumentException("Tried to add earlier removed component " + String.valueOf(component.identifier()));
            }
            if (!component.vanilla() && !(this instanceof GeyserNonVanillaCustomItemDefinition.Builder)) {
                throw new IllegalArgumentException("That component cannot be used for vanilla items");
            }
            if (!dataComponent.validate(value)) {
                throw new IllegalArgumentException("Value " + String.valueOf(value) + " is invalid for " + String.valueOf(component));
            }
            this.components.put(component, value);
            return this;
        }

        @Override
        public CustomItemDefinition.Builder removeComponent(@NonNull Identifier component) {
            Objects.requireNonNull(component, "component cannot be null");
            if (this.components.keySet().stream().map(ItemDataComponent::identifier).anyMatch(identifier -> identifier.equals(component))) {
                throw new IllegalArgumentException("Tried to remove earlier added component " + String.valueOf(component));
            }
            this.removedComponents.add(component);
            return this;
        }

        public void renderOffsets(CustomRenderOffsets offsets) {
            this.renderOffsets = offsets;
        }

        public void isOldConvertedItem() {
            this.isOldConvertedItem = true;
        }

        public void textureSize(int textureSize) {
            this.textureSize = textureSize;
        }

        @Override
        public CustomItemDefinition build() {
            return new GeyserCustomItemDefinition(this);
        }
    }

    private record ComponentMapItem(Reference2ObjectMap<ItemDataComponent<?>, Object> components) implements ItemDataComponentMap
    {
        @Override
        public <T> T get(ItemDataComponent<T> type) {
            return (T)this.components.get(type);
        }

        @Override
        public Set<ItemDataComponent<?>> keySet() {
            return this.components.keySet();
        }
    }
}

