/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.util.Holders;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public record HoldersImpl(@Nullable List<@NonNull Identifier> identifiers, @Nullable Identifier tag) implements Holders
{
    public HolderSet toHolderSet(GeyserSession session, JavaRegistryKey<?> registry) {
        if (this.identifiers != null) {
            return new HolderSet(this.identifiers.stream().map(MinecraftKey::identifierToKey).mapToInt(key -> registry.networkId(session, (Key)key)).toArray());
        }
        return new HolderSet(Objects.requireNonNull(MinecraftKey.identifierToKey(this.tag)));
    }

    public static class Builder
    implements Holders.Builder {
        private final List<Identifier> identifiers = new ArrayList<Identifier>();
        private Identifier tag;

        @Override
        public Holders.Builder with(@NonNull Identifier identifier) {
            Objects.requireNonNull(identifier, "identifier cannot be null");
            if (this.tag != null) {
                throw new IllegalArgumentException("holders uses a tag");
            }
            this.identifiers.add(identifier);
            return this;
        }

        @Override
        public Holders.Builder tag(@NonNull Identifier tag) {
            Objects.requireNonNull(tag, "tag cannot be null");
            if (!this.identifiers.isEmpty()) {
                throw new IllegalArgumentException("holders uses a single identifier or a list thereof");
            }
            this.tag = tag;
            return this;
        }

        @Override
        public Holders build() {
            if (this.identifiers.isEmpty()) {
                Objects.requireNonNull(this.tag, "must have at least a single identifier or a tag");
                return new HoldersImpl(null, this.tag);
            }
            return new HoldersImpl(this.identifiers, this.tag);
        }
    }
}

