/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.merchant.VillagerEntity;
import org.geysermc.geyser.entity.type.living.monster.ZombieEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.VillagerData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ZombieVillagerEntity
extends ZombieEntity {
    public ZombieVillagerEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setTransforming(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.IS_TRANSFORMING, entityMetadata.getPrimitiveValue());
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    public void setZombieVillagerData(EntityMetadata<VillagerData, ?> entityMetadata) {
        VillagerData villagerData = (VillagerData)entityMetadata.getValue();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, VillagerEntity.getBedrockProfession(villagerData.getProfession()));
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, VillagerEntity.getBedrockRegion(villagerData.getType()));
        this.dirtyMetadata.put(EntityDataTypes.TRADE_TIER, villagerData.getLevel() - 1);
    }

    @Override
    protected boolean isShaking() {
        return this.getFlag(EntityFlag.IS_TRANSFORMING) || super.isShaking();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.GOLDEN_APPLE)) {
            return InteractiveTag.CURE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.GOLDEN_APPLE)) {
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

