/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;

public class EnderDragonPartEntity
extends Entity {
    public EnderDragonPartEntity(GeyserSession session, int entityId, long geyserId, float width, float height) {
        super(EnderDragonPartEntity.dragonPartSpawnContext(session, entityId, geyserId));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(width));
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(height));
        this.setFlag(EntityFlag.INVISIBLE, true);
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setPosition(position);
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.getQueuedImmediatelyPackets().add((BedrockPacket)moveEntityPacket);
    }

    public static EntitySpawnContext dragonPartSpawnContext(GeyserSession session, int entityId, long geyserId) {
        return new EntitySpawnContext(session, EntityDefinitions.ENDER_DRAGON_PART, entityId, geyserId);
    }
}

