/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.VariantIntHolder;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class CatEntity
extends TameableEntity
implements VariantIntHolder {
    private byte collarColor = (byte)14;

    public CatEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, 1);
    }

    @Override
    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.moveRelativeRaw(0.0, 0.0, 0.0, yaw, pitch, yaw, isOnGround);
    }

    @Override
    protected float getAdultSize() {
        return 0.8f;
    }

    @Override
    protected float getBabySize() {
        return 0.4f;
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        super.setTameableFlags(entityMetadata);
        this.updateCollarColor();
    }

    @Override
    public JavaRegistryKey<BuiltInVariant> variantRegistry() {
        return JavaRegistries.CAT_VARIANT;
    }

    @Override
    public void setBedrockVariantId(int bedrockId) {
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, bedrockId);
    }

    public void setResting(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.RESTING, entityMetadata.getPrimitiveValue());
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        this.updateCollarColor();
    }

    private void updateCollarColor() {
        if (this.getFlag(EntityFlag.TAMED)) {
            this.dirtyMetadata.put(EntityDataTypes.COLOR, this.collarColor);
        }
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.CAT_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tamed = this.getFlag(EntityFlag.TAMED);
        if (tamed && this.ownerBedrockId == this.session.getPlayerEntity().geyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return !this.canEat(itemInHand) || this.health >= this.maxHealth && tamed ? InteractiveTag.NONE : InteractiveTag.FEED;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tamed = this.getFlag(EntityFlag.TAMED);
        if (tamed && this.ownerBedrockId == this.session.getPlayerEntity().geyserId()) {
            return InteractionResult.SUCCESS;
        }
        return !this.canEat(itemInHand) || this.health >= this.maxHealth && tamed ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    public static enum BuiltInVariant implements VariantIntHolder.BuiltIn
    {
        WHITE,
        BLACK,
        RED,
        SIAMESE,
        BRITISH_SHORTHAIR,
        CALICO,
        PERSIAN,
        RAGDOLL,
        TABBY,
        ALL_BLACK,
        JELLIE;

    }
}

