/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class HoglinEntity
extends AnimalEntity {
    private boolean isImmuneToZombification;

    public HoglinEntity(EntitySpawnContext context) {
        super(context);
        this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, this.session.getPlayerEntity().geyserId());
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    public void setImmuneToZombification(BooleanEntityMetadata entityMetadata) {
        this.isImmuneToZombification = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    @Override
    protected boolean isShaking() {
        return !this.isImmuneToZombification && !this.session.getDimensionType().piglinSafe() || super.isShaking();
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.HOGLIN_FOOD;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }

    @Override
    public boolean useArmSwingAttack() {
        return true;
    }
}

