/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import java.util.concurrent.CompletableFuture;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.AgeableWaterEntity;
import org.geysermc.geyser.level.block.BlockStateValues;

public class SquidEntity
extends AgeableWaterEntity
implements Tickable {
    private float targetPitch;
    private float targetYaw;
    private Vector3i lastPosition;
    private CompletableFuture<Boolean> inWater = CompletableFuture.completedFuture(Boolean.FALSE);

    public SquidEntity(EntitySpawnContext context) {
        super(context);
        this.lastPosition = this.position.toInt();
    }

    @Override
    public void tick() {
        float oldPitch = this.pitch;
        if (this.inWater.join().booleanValue()) {
            float oldYaw = this.yaw;
            this.pitch += (this.targetPitch - this.pitch) * 0.1f;
            this.yaw += (this.targetYaw - this.yaw) * 0.1f;
            this.dirtyYaw = oldYaw != this.yaw;
        } else {
            this.pitch += (-90.0f - this.pitch) * 0.02f;
            this.dirtyYaw = false;
        }
        boolean bl = this.dirtyPitch = oldPitch != this.pitch;
        if (this.getLerpSteps() == 0 && (this.dirtyPitch || this.dirtyYaw)) {
            MoveEntityDeltaPacket packet = new MoveEntityDeltaPacket();
            packet.setRuntimeEntityId(this.geyserId);
            if (this.dirtyPitch) {
                packet.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
                packet.setPitch(this.pitch);
                this.dirtyPitch = false;
            }
            if (this.dirtyYaw) {
                packet.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
                packet.setYaw(this.yaw);
                this.dirtyYaw = false;
            }
            this.session.sendUpstreamPacket((BedrockPacket)packet);
        }
        super.tick();
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        this.checkInWater();
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsoluteRaw(position, yaw, pitch, headYaw, isOnGround, teleported);
        this.checkInWater();
    }

    @Override
    public void setYaw(float yaw) {
        if (!this.inWater.join().booleanValue()) {
            this.yaw = yaw;
        }
    }

    @Override
    public void setPitch(float pitch) {
    }

    @Override
    public void setHeadYaw(float headYaw) {
    }

    @Override
    public void setMotion(Vector3f motion) {
        super.setMotion(motion);
        double horizontalSpeed = Math.sqrt(motion.getX() * motion.getX() + motion.getZ() * motion.getZ());
        this.targetPitch = (float)Math.toDegrees(-Math.atan2(horizontalSpeed, motion.getY()));
        this.targetYaw = (float)Math.toDegrees(-Math.atan2(motion.getX(), motion.getZ()));
    }

    @Override
    public Vector3f getBedrockRotation() {
        return Vector3f.from((float)this.getPitch(), (float)this.getYaw(), (float)this.getYaw());
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    private void checkInWater() {
        Vector3i newPosition = this.position.toInt();
        if (newPosition.equals(this.lastPosition)) {
            return;
        }
        this.lastPosition = newPosition;
        this.inWater = this.getFlag(EntityFlag.RIDING) ? CompletableFuture.completedFuture(false) : this.session.getGeyser().getWorldManager().getBlockAtAsync(this.session, newPosition).thenApply(block -> BlockStateValues.getWaterLevel(block) != -1);
    }
}

