/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.AddPaintingPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.HangingEntity;
import org.geysermc.geyser.level.PaintingType;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.PaintingVariant;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;

public class PaintingEntity
extends HangingEntity {
    private static final double OFFSET = -0.46875;
    private int paintingId = -1;
    private Direction direction = Direction.SOUTH;

    public PaintingEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void spawnEntity() {
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
        this.updatePainting();
    }

    public void setPaintingType(ObjectEntityMetadata<Holder<PaintingVariant>> entityMetadata) {
        if (!((Holder)entityMetadata.getValue()).isId()) {
            return;
        }
        this.paintingId = ((Holder)entityMetadata.getValue()).id();
        this.updatePainting();
    }

    private void updatePainting() {
        PaintingType type;
        if (this.paintingId == -1) {
            return;
        }
        if (this.valid) {
            this.despawnEntity();
        }
        if ((type = this.session.getRegistryCache().registry(JavaRegistries.PAINTING_VARIANT).byId(this.paintingId)) == null) {
            return;
        }
        AddPaintingPacket addPaintingPacket = new AddPaintingPacket();
        addPaintingPacket.setUniqueEntityId(this.geyserId);
        addPaintingPacket.setRuntimeEntityId(this.geyserId);
        addPaintingPacket.setMotive(type.getBedrockName());
        addPaintingPacket.setPosition(this.fixOffset(type));
        addPaintingPacket.setDirection(switch (this.direction) {
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 1;
            case Direction.NORTH -> 2;
            case Direction.EAST -> 3;
            default -> 0;
        });
        this.session.sendUpstreamPacket((BedrockPacket)addPaintingPacket);
        this.valid = true;
        this.session.getGeyser().getLogger().debug("Spawned painting on " + String.valueOf(this.position));
    }

    @Override
    public void updateHeadLookRotation(float headYaw) {
    }

    private Vector3f fixOffset(PaintingType paintingName) {
        Vector3f position = this.position;
        if (this.session.isEmulatePost1_18Logic()) {
            position = position.add(0.5, 0.5, 0.5);
        }
        double widthOffset = paintingName.getWidth() > 1 && paintingName.getWidth() != 3 ? 0.5 : 0.0;
        double heightOffset = paintingName.getHeight() > 1 && paintingName.getHeight() != 3 ? 0.5 : 0.0;
        return switch (this.direction) {
            case Direction.SOUTH -> position.add(widthOffset, heightOffset, -0.46875);
            case Direction.WEST -> position.add(0.46875, heightOffset, widthOffset);
            case Direction.NORTH -> position.add(-widthOffset, heightOffset, 0.46875);
            case Direction.EAST -> position.add(-0.46875, heightOffset, -widthOffset);
            default -> position;
        };
    }
}

