/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.item.custom.v2;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponentMap;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.PredicateStrategy;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.util.GenericBuilder;
import org.geysermc.geyser.api.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface CustomItemDefinition {
    public @NonNull Identifier bedrockIdentifier();

    public @NonNull String displayName();

    public @NonNull Identifier model();

    public @NonNull String icon();

    public @NonNull List<MinecraftPredicate<? super ItemPredicateContext>> predicates();

    public @NonNull PredicateStrategy predicateStrategy();

    public int priority();

    public @NonNull CustomItemBedrockOptions bedrockOptions();

    public @NonNull ItemDataComponentMap components();

    public @NonNull List<Identifier> removedComponents();

    public static Builder builder(@NonNull Identifier bedrockIdentifier, @NonNull Identifier itemModel) {
        return (Builder)GeyserApi.api().provider(Builder.class, bedrockIdentifier, itemModel);
    }

    public static interface Builder
    extends GenericBuilder<CustomItemDefinition> {
        public @This Builder displayName(@NonNull String var1);

        public @This Builder priority(int var1);

        public @This Builder bedrockOptions(@NonNull CustomItemBedrockOptions.Builder var1);

        public @This Builder predicate(@NonNull MinecraftPredicate<? super ItemPredicateContext> var1);

        public @This Builder predicateStrategy(@NonNull PredicateStrategy var1);

        public <T> @This Builder component(@NonNull ItemDataComponent<T> var1, @NonNull T var2);

        default public <T> @This Builder component(@NonNull ItemDataComponent<T> component, @NonNull GenericBuilder<T> builder) {
            return this.component(component, builder.build());
        }

        public @This Builder removeComponent(@NonNull Identifier var1);

        default public @This Builder removeComponent(@NonNull ItemDataComponent<?> component) {
            Objects.requireNonNull(component);
            if (!component.vanilla()) {
                throw new IllegalArgumentException("Cannot remove non-vanilla component");
            }
            return this.removeComponent(component.identifier());
        }

        @Override
        public CustomItemDefinition build();
    }
}

