/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundSetPlayerInventoryPacket
implements MinecraftPacket {
    private final int slot;
    private final ItemStack contents;

    public ClientboundSetPlayerInventoryPacket(ByteBuf in) {
        this.slot = MinecraftTypes.readVarInt(in);
        this.contents = MinecraftTypes.readOptionalItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.slot);
        MinecraftTypes.writeOptionalItemStack(out, this.contents);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getContents() {
        return this.contents;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetPlayerInventoryPacket)) {
            return false;
        }
        ClientboundSetPlayerInventoryPacket other = (ClientboundSetPlayerInventoryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$contents = this.getContents();
        ItemStack other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetPlayerInventoryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        ItemStack $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetPlayerInventoryPacket(slot=" + this.getSlot() + ", contents=" + String.valueOf(this.getContents()) + ")";
    }

    public @NonNull ClientboundSetPlayerInventoryPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientboundSetPlayerInventoryPacket(slot, this.contents);
    }

    public @NonNull ClientboundSetPlayerInventoryPacket withContents(ItemStack contents) {
        return this.contents == contents ? this : new ClientboundSetPlayerInventoryPacket(this.slot, contents);
    }

    public ClientboundSetPlayerInventoryPacket(int slot, ItemStack contents) {
        this.slot = slot;
        this.contents = contents;
    }
}

