/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PositionElement;

public class ClientboundPlayerPositionPacket
implements MinecraftPacket {
    private final int id;
    private final Vector3d position;
    private final Vector3d deltaMovement;
    private final float yRot;
    private final float xRot;
    @lombok.NonNull
    private final List<PositionElement> relatives;

    public ClientboundPlayerPositionPacket(int id, double x, double y, double z, double dX, double dY, double dZ, float yRot, float xRot, PositionElement ... relative) {
        this(id, Vector3d.from((double)x, (double)y, (double)z), Vector3d.from((double)dX, (double)dY, (double)dZ), yRot, xRot, Arrays.asList(relative != null ? relative : new PositionElement[]{}));
    }

    public ClientboundPlayerPositionPacket(ByteBuf in) {
        this.id = MinecraftTypes.readVarInt(in);
        this.position = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.deltaMovement = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
        this.relatives = new ArrayList<PositionElement>();
        int flags = in.readInt();
        for (PositionElement element : PositionElement.values()) {
            int bit = 1 << element.ordinal();
            if ((flags & bit) != bit) continue;
            this.relatives.add(element);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.id);
        out.writeDouble(this.position.getX());
        out.writeDouble(this.position.getY());
        out.writeDouble(this.position.getZ());
        out.writeDouble(this.deltaMovement.getX());
        out.writeDouble(this.deltaMovement.getY());
        out.writeDouble(this.deltaMovement.getZ());
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
        int flags = 0;
        for (PositionElement element : this.relatives) {
            flags |= 1 << element.ordinal();
        }
        out.writeInt(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getDeltaMovement() {
        return this.deltaMovement;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    @lombok.NonNull
    public List<PositionElement> getRelatives() {
        return this.relatives;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerPositionPacket)) {
            return false;
        }
        ClientboundPlayerPositionPacket other = (ClientboundPlayerPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        Vector3d this$position = this.getPosition();
        Vector3d other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3d this$deltaMovement = this.getDeltaMovement();
        Vector3d other$deltaMovement = other.getDeltaMovement();
        if (this$deltaMovement == null ? other$deltaMovement != null : !this$deltaMovement.equals(other$deltaMovement)) {
            return false;
        }
        List<PositionElement> this$relatives = this.getRelatives();
        List<PositionElement> other$relatives = other.getRelatives();
        return !(this$relatives == null ? other$relatives != null : !((Object)this$relatives).equals(other$relatives));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        Vector3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3d $deltaMovement = this.getDeltaMovement();
        result = result * 59 + ($deltaMovement == null ? 43 : $deltaMovement.hashCode());
        List<PositionElement> $relatives = this.getRelatives();
        result = result * 59 + ($relatives == null ? 43 : ((Object)$relatives).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerPositionPacket(id=" + this.getId() + ", position=" + String.valueOf(this.getPosition()) + ", deltaMovement=" + String.valueOf(this.getDeltaMovement()) + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ", relatives=" + String.valueOf(this.getRelatives()) + ")";
    }

    public @NonNull ClientboundPlayerPositionPacket withId(int id) {
        return this.id == id ? this : new ClientboundPlayerPositionPacket(id, this.position, this.deltaMovement, this.yRot, this.xRot, this.relatives);
    }

    public @NonNull ClientboundPlayerPositionPacket withPosition(Vector3d position) {
        return this.position == position ? this : new ClientboundPlayerPositionPacket(this.id, position, this.deltaMovement, this.yRot, this.xRot, this.relatives);
    }

    public @NonNull ClientboundPlayerPositionPacket withDeltaMovement(Vector3d deltaMovement) {
        return this.deltaMovement == deltaMovement ? this : new ClientboundPlayerPositionPacket(this.id, this.position, deltaMovement, this.yRot, this.xRot, this.relatives);
    }

    public @NonNull ClientboundPlayerPositionPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundPlayerPositionPacket(this.id, this.position, this.deltaMovement, yRot, this.xRot, this.relatives);
    }

    public @NonNull ClientboundPlayerPositionPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundPlayerPositionPacket(this.id, this.position, this.deltaMovement, this.yRot, xRot, this.relatives);
    }

    public @NonNull ClientboundPlayerPositionPacket withRelatives(@lombok.NonNull List<PositionElement> relatives) {
        if (relatives == null) {
            throw new NullPointerException("relatives is marked non-null but is null");
        }
        return this.relatives == relatives ? this : new ClientboundPlayerPositionPacket(this.id, this.position, this.deltaMovement, this.yRot, this.xRot, relatives);
    }

    public ClientboundPlayerPositionPacket(int id, Vector3d position, Vector3d deltaMovement, float yRot, float xRot, @lombok.NonNull List<PositionElement> relatives) {
        if (relatives == null) {
            throw new NullPointerException("relatives is marked non-null but is null");
        }
        this.id = id;
        this.position = position;
        this.deltaMovement = deltaMovement;
        this.yRot = yRot;
        this.xRot = xRot;
        this.relatives = relatives;
    }
}

