/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectInstance;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public interface ConsumeEffect {

    public record PlaySound(Sound sound) implements ConsumeEffect
    {
    }

    public record TeleportRandomly(float diameter) implements ConsumeEffect
    {
    }

    public record ClearAllEffects() implements ConsumeEffect
    {
    }

    public record RemoveEffects(HolderSet effects) implements ConsumeEffect
    {
    }

    public record ApplyEffects(List<MobEffectInstance> effects, float probability) implements ConsumeEffect
    {
        public ApplyEffects(List<MobEffectInstance> effects, float probability) {
            this.effects = List.copyOf(effects);
            this.probability = probability;
        }

        public static @NonNull ApplyEffectsBuilder builder() {
            return new ApplyEffectsBuilder();
        }

        public @NonNull ApplyEffectsBuilder toBuilder() {
            return new ApplyEffectsBuilder().effects(this.effects).probability(this.probability);
        }

        public static class ApplyEffectsBuilder {
            private List<MobEffectInstance> effects;
            private float probability;

            ApplyEffectsBuilder() {
            }

            public @NonNull ApplyEffectsBuilder effects(List<MobEffectInstance> effects) {
                this.effects = effects;
                return this;
            }

            public @NonNull ApplyEffectsBuilder probability(float probability) {
                this.probability = probability;
                return this;
            }

            public @NonNull ApplyEffects build() {
                return new ApplyEffects(this.effects, this.probability);
            }

            public @NonNull String toString() {
                return "ConsumeEffect.ApplyEffects.ApplyEffectsBuilder(effects=" + String.valueOf(this.effects) + ", probability=" + this.probability + ")";
            }
        }
    }
}

